/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.spi;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.teiid.core.TeiidException;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnection;
import org.teiid.resource.spi.BasicResourceAdapter;
import org.teiid.resource.spi.ConnectionContext;
import org.teiid.resource.spi.ConnectionRequestInfoWrapper;

public abstract class BasicManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
ValidatingManagedConnectionFactory {
    private static final long serialVersionUID = -7302713800883776790L;
    private PrintWriter log;
    private BasicResourceAdapter ra;

    public abstract Object createConnectionFactory() throws ResourceException;

    public Object createConnectionFactory(ConnectionManager arg0) throws ResourceException {
        return this.createConnectionFactory();
    }

    public ManagedConnection createManagedConnection(Subject arg0, ConnectionRequestInfo arg1) throws ResourceException {
        ConnectionRequestInfoWrapper criw = (ConnectionRequestInfoWrapper)arg1;
        ConnectionContext.setSubject(arg0);
        BasicConnection connection = criw.cf.getConnection();
        ConnectionContext.setSubject(null);
        return new BasicManagedConnection(connection);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.log;
    }

    public ManagedConnection matchManagedConnections(Set arg0, Subject arg1, ConnectionRequestInfo arg2) throws ResourceException {
        return (ManagedConnection)arg0.iterator().next();
    }

    public void setLogWriter(PrintWriter arg0) throws ResourceException {
        this.log = arg0;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter arg0) throws ResourceException {
        this.ra = (BasicResourceAdapter)arg0;
    }

    public static <T> T getInstance(Class<T> expectedType, String className, Collection ctorObjs, Class defaultClass) throws ResourceException {
        try {
            if (className == null) {
                if (defaultClass == null) {
                    throw new ResourceException("Neither class name or default class specified to create an instance");
                }
                return expectedType.cast(defaultClass.newInstance());
            }
            return expectedType.cast(ReflectionHelper.create((String)className, (Collection)ctorObjs, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        catch (TeiidException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public Set<BasicManagedConnection> getInvalidConnections(Set arg0) throws ResourceException {
        HashSet<BasicManagedConnection> result = new HashSet<BasicManagedConnection>();
        for (Object object : arg0) {
            BasicManagedConnection bmc;
            if (!(object instanceof BasicManagedConnection) || (bmc = (BasicManagedConnection)object).isValid()) continue;
            result.add(bmc);
        }
        return result;
    }
}

