/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Schema;

public class Table
extends ColumnSet<Schema> {
    private static final long serialVersionUID = 4891356771125218672L;
    private int cardinality;
    private Type tableType;
    private boolean isVirtual;
    private boolean isSystem;
    private boolean isMaterialized;
    private boolean supportsUpdate;
    private List<ForeignKey> foriegnKeys = new LinkedList<ForeignKey>();
    private List<KeyRecord> indexes = new LinkedList<KeyRecord>();
    private List<KeyRecord> uniqueKeys = new LinkedList<KeyRecord>();
    private List<KeyRecord> accessPatterns = new LinkedList<KeyRecord>();
    private KeyRecord primaryKey;
    private String selectTransformation;
    private String insertPlan;
    private String updatePlan;
    private String deletePlan;
    private Table materializedStageTable;
    private Table materializedTable;
    private List<String> bindings;
    private List<String> schemaPaths;
    private String resourcePath;

    public List<String> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<String> bindings) {
        this.bindings = bindings;
    }

    public List<String> getSchemaPaths() {
        return this.schemaPaths;
    }

    public void setSchemaPaths(List<String> schemaPaths) {
        this.schemaPaths = schemaPaths;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public boolean isPhysical() {
        return !this.isVirtual();
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public Type getTableType() {
        if (this.tableType == null) {
            return Type.Table;
        }
        return this.tableType;
    }

    public boolean supportsUpdate() {
        return this.supportsUpdate;
    }

    public void setCardinality(int i) {
        this.cardinality = i;
    }

    public void setTableType(Type i) {
        this.tableType = i;
    }

    public void setSupportsUpdate(boolean b) {
        this.supportsUpdate = b;
    }

    public void setVirtual(boolean b) {
        this.isVirtual = b;
    }

    public void setMaterialized(boolean isMaterialized) {
        this.isMaterialized = isMaterialized;
    }

    public void setSystem(boolean b) {
        this.isSystem = b;
    }

    public String getInsertPlan() {
        return this.insertPlan;
    }

    public String getUpdatePlan() {
        return this.updatePlan;
    }

    public String getDeletePlan() {
        return this.deletePlan;
    }

    public void setInsertPlan(String insertPlan) {
        this.insertPlan = insertPlan;
    }

    public void setUpdatePlan(String updatePlan) {
        this.updatePlan = updatePlan;
    }

    public void setDeletePlan(String deletePlan) {
        this.deletePlan = deletePlan;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foriegnKeys;
    }

    public void setForiegnKeys(List<ForeignKey> foriegnKeys) {
        this.foriegnKeys = foriegnKeys;
    }

    public List<KeyRecord> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<KeyRecord> indexes) {
        this.indexes = indexes;
    }

    public List<KeyRecord> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setUniqueKeys(List<KeyRecord> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public List<KeyRecord> getAccessPatterns() {
        return this.accessPatterns;
    }

    public void setAccessPatterns(List<KeyRecord> accessPatterns) {
        this.accessPatterns = accessPatterns;
    }

    public KeyRecord getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(KeyRecord primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getSelectTransformation() {
        return this.selectTransformation;
    }

    public void setSelectTransformation(String selectTransformation) {
        this.selectTransformation = selectTransformation;
    }

    public Table getMaterializedStageTable() {
        return this.materializedStageTable;
    }

    public Table getMaterializedTable() {
        return this.materializedTable;
    }

    public void setMaterializedStageTable(Table materializedStageTable) {
        this.materializedStageTable = materializedStageTable;
    }

    public void setMaterializedTable(Table materializedTable) {
        this.materializedTable = materializedTable;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public Collection<KeyRecord> getAllKeys() {
        LinkedList<KeyRecord> keys = new LinkedList<KeyRecord>();
        if (this.getPrimaryKey() != null) {
            keys.add(this.getPrimaryKey());
        }
        keys.addAll(this.getForeignKeys());
        keys.addAll(this.getAccessPatterns());
        keys.addAll(this.getIndexes());
        keys.addAll(this.getUniqueKeys());
        return keys;
    }

    @Override
    public void addColumn(Column column) {
        super.addColumn(column);
        column.setParent(this);
    }

    public static enum Type {
        Table,
        View,
        Document,
        XmlMappingClass,
        XmlStagingTable,
        MaterializedTable;

    }
}

