/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.connector.DataPlugin;
import org.teiid.core.id.UUIDFactory;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;

public class MetadataFactory {
    private Schema schema;
    private UUIDFactory factory = new UUIDFactory();
    private Map<String, Datatype> dataTypes;
    private Properties importProperties;
    private MetadataStore store = new MetadataStore();

    public MetadataFactory(String modelName, Map<String, Datatype> dataTypes, Properties importProperties) {
        this.dataTypes = dataTypes;
        this.schema = new Schema();
        this.schema.setName(modelName);
        this.setUUID(this.schema);
        this.store.addSchema(this.schema);
        this.importProperties = importProperties;
    }

    public MetadataStore getMetadataStore() {
        return this.store;
    }

    public Properties getImportProperties() {
        return this.importProperties;
    }

    private void setUUID(AbstractMetadataRecord record) {
        record.setUUID(this.factory.create().toString());
    }

    public Table addTable(String name) throws TranslatorException {
        Table table = new Table();
        table.setTableType(Table.Type.Table);
        table.setName(name);
        this.setUUID(table);
        this.schema.addTable(table);
        return table;
    }

    public Column addColumn(String name, String type, ColumnSet<?> table) throws TranslatorException {
        if (name.indexOf(46) != -1) {
            throw new TranslatorException(DataPlugin.Util.getString("MetadataFactory.invalid_name", new Object[]{name}));
        }
        Column column = new Column();
        column.setName(name);
        table.addColumn(column);
        column.setPosition(table.getColumns().size());
        Datatype datatype = this.setColumnType(type, column);
        column.setCaseSensitive(datatype.isCaseSensitive());
        column.setAutoIncremented(datatype.isAutoIncrement());
        column.setSigned(datatype.isSigned());
        this.setUUID(column);
        return column;
    }

    private Datatype setColumnType(String type, BaseColumn column) throws TranslatorException {
        Datatype datatype = this.dataTypes.get(type);
        if (datatype == null) {
            throw new TranslatorException(DataPlugin.Util.getString("MetadataFactory.unknown_datatype", new Object[]{type}));
        }
        column.setDatatype(datatype);
        column.setDatatypeUUID(datatype.getUUID());
        column.setLength(datatype.getLength());
        column.setPrecision(datatype.getPrecisionLength());
        column.setRadix(datatype.getRadix());
        column.setRuntimeType(datatype.getRuntimeTypeName());
        return datatype;
    }

    public KeyRecord addPrimaryKey(String name, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord primaryKey = new KeyRecord(KeyRecord.Type.Primary);
        primaryKey.setParent(table);
        primaryKey.setColumns(new ArrayList<Column>(columnNames.size()));
        primaryKey.setName(name);
        this.setUUID(primaryKey);
        this.assignColumns(columnNames, table, primaryKey);
        table.setPrimaryKey(primaryKey);
        return primaryKey;
    }

    public KeyRecord addAccessPattern(String name, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord ap = new KeyRecord(KeyRecord.Type.AccessPattern);
        ap.setParent(table);
        ap.setColumns(new ArrayList<Column>(columnNames.size()));
        ap.setName(name);
        this.setUUID(ap);
        this.assignColumns(columnNames, table, ap);
        table.getAccessPatterns().add(ap);
        return ap;
    }

    public KeyRecord addIndex(String name, boolean nonUnique, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord index = new KeyRecord(nonUnique ? KeyRecord.Type.NonUnique : KeyRecord.Type.Index);
        index.setParent(table);
        index.setColumns(new ArrayList<Column>(columnNames.size()));
        index.setName(name);
        this.setUUID(index);
        this.assignColumns(columnNames, table, index);
        table.getIndexes().add(index);
        return index;
    }

    public ForeignKey addForiegnKey(String name, List<String> columnNames, Table pkTable, Table table) throws TranslatorException {
        ForeignKey foreignKey = new ForeignKey();
        foreignKey.setParent(table);
        foreignKey.setColumns(new ArrayList<Column>(columnNames.size()));
        foreignKey.setName(name);
        this.setUUID(foreignKey);
        if (pkTable.getPrimaryKey() == null) {
            throw new TranslatorException("No primary key defined for table " + pkTable);
        }
        foreignKey.setPrimaryKey(pkTable.getPrimaryKey());
        foreignKey.setUniqueKeyID(pkTable.getPrimaryKey().getUUID());
        this.assignColumns(columnNames, table, foreignKey);
        table.getForeignKeys().add(foreignKey);
        return foreignKey;
    }

    public Procedure addProcedure(String name) throws TranslatorException {
        Procedure procedure = new Procedure();
        procedure.setName(name);
        this.setUUID(procedure);
        procedure.setParameters(new LinkedList<ProcedureParameter>());
        this.schema.addProcedure(procedure);
        return procedure;
    }

    public ProcedureParameter addProcedureParameter(String name, String type, ProcedureParameter.Type parameterType, Procedure procedure) throws TranslatorException {
        ProcedureParameter param = new ProcedureParameter();
        param.setName(name);
        this.setUUID(param);
        param.setType(parameterType);
        param.setProcedure(procedure);
        this.setColumnType(type, param);
        procedure.getParameters().add(param);
        param.setPosition(procedure.getParameters().size());
        return param;
    }

    public Column addProcedureResultSetColumn(String name, String type, Procedure procedure) throws TranslatorException {
        if (procedure.getResultSet() == null) {
            ColumnSet<Procedure> resultSet = new ColumnSet<Procedure>();
            resultSet.setParent(procedure);
            resultSet.setName("RSParam");
            this.setUUID(resultSet);
            procedure.setResultSet(resultSet);
        }
        return this.addColumn(name, type, procedure.getResultSet());
    }

    private void assignColumns(List<String> columnNames, Table table, ColumnSet<?> columns) throws TranslatorException {
        for (String columnName : columnNames) {
            boolean match = false;
            for (Column column : table.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                match = true;
                columns.getColumns().add(column);
                break;
            }
            if (match) continue;
            throw new TranslatorException(DataPlugin.Util.getString("MetadataFactory.no_column_found", new Object[]{columnName}));
        }
    }
}

