/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.core.util.EquivalenceUtil;

public abstract class AbstractMetadataRecord
implements Serializable {
    private static final long serialVersionUID = 564092984812414058L;
    public static final char NAME_DELIM_CHAR = '.';
    private static AtomicLong UUID_SEQUENCE = new AtomicLong();
    private String uuid;
    private String name;
    private String nameInSource;
    private LinkedHashMap<String, String> properties;
    private String annotation;

    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = String.valueOf(UUID_SEQUENCE.getAndIncrement());
        }
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getNameInSource() {
        return this.nameInSource;
    }

    public void setNameInSource(String nameInSource) {
        this.nameInSource = nameInSource;
    }

    public String getFullName() {
        AbstractMetadataRecord parent = this.getParent();
        if (parent != null) {
            return parent.getFullName() + '.' + this.getName();
        }
        return this.name;
    }

    public AbstractMetadataRecord getParent() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getClass().getSimpleName());
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(", nameInSource=");
        sb.append(this.getNameInSource());
        sb.append(", uuid=");
        sb.append(this.getUUID());
        return sb.toString();
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        this.properties.put(key, value);
    }

    public void setProperties(LinkedHashMap<String, String> properties) {
        this.properties = properties;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMetadataRecord other = (AbstractMetadataRecord)obj;
        return EquivalenceUtil.areEqual((Object)this.getUUID(), (Object)other.getUUID());
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }
}

