/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.switchboard.spi.EnvironmentEntryType;
import org.jboss.switchboard.spi.ResourceProvider;

public class ResourceProviderRegistry<C> {
    private Map<Class<?>, ResourceProvider<C, ? extends EnvironmentEntryType>> bindingProviders = new ConcurrentHashMap();

    public void registerProviders(Collection<ResourceProvider<C, ? extends EnvironmentEntryType>> providers) {
        if (providers == null) {
            throw new IllegalArgumentException("ENCBindingProvider(s) cannot be null during registration");
        }
        for (ResourceProvider<C, EnvironmentEntryType> resourceProvider : providers) {
            this.registerProvider(resourceProvider);
        }
    }

    public void registerProvider(ResourceProvider<C, ? extends EnvironmentEntryType> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("ENCBindingProvider cannot be null during registration");
        }
        Class<?> type = this.getProviderEnvEntryType(provider);
        this.bindingProviders.put(type, provider);
    }

    public ResourceProvider<C, ? extends EnvironmentEntryType> getResourceProvider(Class<? extends EnvironmentEntryType> type) {
        Class<?>[] interfaces;
        ResourceProvider<C, ? extends EnvironmentEntryType> provider = this.bindingProviders.get(type);
        if (provider != null) {
            return provider;
        }
        for (Class<? extends EnvironmentEntryType> entryType = type.getSuperclass(); entryType != null && EnvironmentEntryType.class.isAssignableFrom(entryType); entryType = entryType.getSuperclass()) {
            provider = this.getResourceProvider(entryType);
            if (provider == null) continue;
            return provider;
        }
        for (Class<?> intf : interfaces = type.getInterfaces()) {
            if (!EnvironmentEntryType.class.isAssignableFrom(intf) || (provider = this.getResourceProvider(intf)) == null) continue;
            return provider;
        }
        return provider;
    }

    private Class<?> getProviderEnvEntryType(ResourceProvider<C, ? extends EnvironmentEntryType> provider) {
        Type[] interfaces = provider.getClass().getGenericInterfaces();
        Type resourceProviderIntf = null;
        for (Type t : interfaces) {
            ParameterizedType pt = (ParameterizedType)t;
            Type rawType = pt.getRawType();
            if (!(rawType instanceof Class) || !((Class)rawType).getName().equals(ResourceProvider.class.getName())) continue;
            resourceProviderIntf = t;
            break;
        }
        if (resourceProviderIntf == null) {
            throw new IllegalStateException("No generic Processor interface found on: " + provider);
        }
        ParameterizedType pt = (ParameterizedType)resourceProviderIntf;
        Type envEntryTypeParameter = pt.getActualTypeArguments()[1];
        Class evnEntryType = null;
        if (envEntryTypeParameter instanceof Class) {
            evnEntryType = (Class)envEntryTypeParameter;
        } else if (envEntryTypeParameter instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)envEntryTypeParameter;
            evnEntryType = (Class)tv.getBounds()[0];
        }
        return evnEntryType;
    }
}

