/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.io.File;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.xml.namespace.QName;
import org.jboss.soa.bpel.runtime.ws.BaseWebServiceEndpoint;
import org.jboss.soa.bpel.runtime.ws.JavaUtils;
import org.jboss.soa.bpel.runtime.ws.WSDLReference;

public class WebServiceProviderFactory {
    private static final String PKG_PREFIX = WebServiceProviderFactory.class.getPackage().getName() + ".";

    public BaseWebServiceEndpoint createProvider(QName service, String port, String endpointId, WSDLReference wsdlRef, ClassLoader loader, File handlerFile) throws Exception {
        ClassPool pool = new ClassPool(true);
        pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
        pool.importPackage("java.lang");
        pool.importPackage("javax.xml.ws");
        pool.importPackage("javax.jws");
        CtClass stringType = pool.get("java.lang.String");
        String implClassName = PKG_PREFIX + "BPELWebServiceEndpoint_" + endpointId;
        CtClass impl = pool.get("org.jboss.soa.bpel.runtime.ws.TemplateWebServiceEndpoint");
        impl.setName(implClassName);
        CtField idField = new CtField(stringType, "endpointId", impl);
        idField.setModifiers(1);
        impl.addField(idField, "\"" + endpointId + "\"");
        CtField serviceField = new CtField(stringType, "serviceName", impl);
        serviceField.setModifiers(1);
        impl.addField(serviceField, "\"" + service.toString() + "\"");
        CtField wsdlLocationField = new CtField(stringType, "wsdlLocation", impl);
        wsdlLocationField.setModifiers(1);
        impl.addField(wsdlLocationField, "\"" + wsdlRef.getWsdlURL().toExternalForm() + "\"");
        CtField portNameField = new CtField(stringType, "portName", impl);
        portNameField.setModifiers(1);
        impl.addField(portNameField, "\"" + port + "\"");
        ClassFile classFile = impl.getClassFile();
        classFile.setVersionToJava5();
        ConstPool constantPool = classFile.getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constantPool, "RuntimeVisibleAnnotations");
        Annotation providerAnnotation = new Annotation("javax.xml.ws.WebServiceProvider", constantPool);
        providerAnnotation.addMemberValue("serviceName", (MemberValue)new StringMemberValue(service.getLocalPart(), constantPool));
        providerAnnotation.addMemberValue("portName", (MemberValue)new StringMemberValue(port, constantPool));
        providerAnnotation.addMemberValue("targetNamespace", (MemberValue)new StringMemberValue(service.getNamespaceURI(), constantPool));
        providerAnnotation.addMemberValue("wsdlLocation", (MemberValue)new StringMemberValue(wsdlRef.getWsdlURL().toExternalForm(), constantPool));
        attr.addAnnotation(providerAnnotation);
        Annotation annotation2 = new Annotation("javax.xml.ws.ServiceMode", constantPool);
        EnumMemberValue enumValue = new EnumMemberValue(constantPool);
        enumValue.setType("javax.xml.ws.Service$Mode");
        enumValue.setValue("MESSAGE");
        annotation2.addMemberValue("value", (MemberValue)enumValue);
        attr.addAnnotation(annotation2);
        classFile.addAttribute((AttributeInfo)attr);
        if (handlerFile != null) {
            Annotation handlerChain = new Annotation("javax.jws.HandlerChain", constantPool);
            handlerChain.addMemberValue("file", (MemberValue)new StringMemberValue("/" + handlerFile.getName(), constantPool));
            attr.addAnnotation(handlerChain);
        }
        this.createStringGetter(impl, stringType, "endpointId", "getEndpointId");
        this.createStringGetter(impl, stringType, "serviceName", "getServiceName");
        this.createStringGetter(impl, stringType, "wsdlLocation", "getWsdlLocation");
        this.createStringGetter(impl, stringType, "portName", "getPortName");
        impl.stopPruning(false);
        impl.toClass(loader);
        JavaUtils.clearBlacklists(loader);
        Class<?> clazz = loader.loadClass(implClassName);
        BaseWebServiceEndpoint obj = (BaseWebServiceEndpoint)clazz.newInstance();
        return obj;
    }

    private void createStringGetter(CtClass impl, CtClass stringType, String property, String methodName) throws Exception {
        CtMethod method = new CtMethod(stringType, methodName, new CtClass[0], impl);
        StringBuffer body = new StringBuffer();
        body.append("{");
        body.append("return this." + property + ";");
        body.append("}");
        method.setBody(body.toString());
        impl.addMethod(method);
    }
}

