/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.net.URI;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.DOMUtils;
import org.jboss.soa.bpel.runtime.engine.EndpointReference;
import org.jboss.soa.bpel.runtime.engine.PartnerChannel;
import org.jboss.soa.bpel.runtime.engine.ode.BPELEngineImpl;
import org.jboss.soa.bpel.runtime.engine.ode.ExecutionEnvironment;
import org.jboss.soa.bpel.runtime.engine.ode.UDDIClientFactory;
import org.jboss.soa.bpel.runtime.engine.ode.UDDIRegistration;
import org.jboss.soa.bpel.runtime.integration.ServerConfigFactory;
import org.jboss.soa.bpel.runtime.ws.ClientEndpointReference;
import org.jboss.soa.bpel.runtime.ws.DOMWriter;
import org.jboss.soa.bpel.runtime.ws.EndpointMetaData;
import org.jboss.soa.bpel.runtime.ws.JAXWSInitializer;
import org.jboss.soa.bpel.runtime.ws.JavaUtils;
import org.jboss.soa.bpel.runtime.ws.SOAPMessageAdapter;
import org.jboss.soa.bpel.runtime.ws.WSDLHelper;
import org.jboss.soa.bpel.runtime.ws.WSDLReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebServiceClient
implements PartnerChannel {
    private static final String JAXWS_CLIENT_INITIALIZER = "jaxws.client.initializer.impl";
    public static final String BPEL_UDDI_LOOKUP = "uddi.lookup";
    public static final String BPEL_WEBSERVICE_SECURE = "webservice.secure";
    public static final String BPEL_WEBSERVICE_BASEURL = "webservice.baseurl";
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean isInitialized = false;
    private BPELEngineImpl engine;
    private UDDIRegistration uddiRegistration = null;
    private URL wsdlUrl;
    private String id;
    private Dispatch<SOAPMessage> dispatcher = null;
    private EndpointMetaData metaData = null;
    private Definition wsdlDefinition;
    private final QName serviceName;
    private final QName port;
    private SOAPMessageAdapter messageAdapter;
    private ExecutionEnvironment executionEnvironment;
    private URI baseURI;

    public WebServiceClient(EndpointMetaData metaData, ExecutionEnvironment env, BPELEngineImpl engine, ProcessConf pconf) {
        this.engine = engine;
        this.executionEnvironment = env;
        this.metaData = metaData;
        this.id = metaData.getEndpointId();
        this.serviceName = metaData.getServiceName();
        this.port = new QName(this.serviceName.getNamespaceURI(), metaData.getPortName());
        this.baseURI = pconf.getBaseURI();
        this.log.debug((Object)("Web Service Client: Base URI=" + pconf.getBaseURI()));
    }

    private synchronized void initialize() {
        WSDLReference wsdlReference;
        if (this.isUDDILookup()) {
            try {
                String webServiceHost = ServerConfigFactory.getServerConfig().getWebServiceHost();
                int webServicePort = ServerConfigFactory.getServerConfig().getWebServicePort();
                URL url = new URL("http://" + webServiceHost + ":" + webServicePort);
                if (this.isWebserviceSecure()) {
                    int secureWebServicePort = ServerConfigFactory.getServerConfig().getWebServicePort();
                    url = new URL("https://" + webServiceHost + ":" + secureWebServicePort);
                }
                if (this.engine.getOdeConfig().getProperty(BPEL_WEBSERVICE_BASEURL) == null) {
                    this.engine.getOdeConfig().getProperties().setProperty(BPEL_WEBSERVICE_BASEURL, url.toExternalForm());
                }
                this.uddiRegistration = UDDIClientFactory.newInstance(this.engine.getOdeConfig().getProperties());
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage());
                this.log.error((Object)"Continuing without UDDI integration.");
            }
        }
        if (this.isUDDILookup() && (wsdlReference = this.uddiRegistration.lookupWSDL(this.metaData.getServiceName(), this.metaData.getPortName())) != null) {
            this.wsdlDefinition = wsdlReference.getDefinition();
            this.wsdlUrl = wsdlReference.getWsdlURL();
        }
        if (!this.isUDDILookup() || this.wsdlUrl == null) {
            wsdlReference = new WSDLHelper().createWSDLReference(this.engine, this.metaData.getProcessId(), this.metaData.getServiceName(), this.metaData.getPortName());
            this.wsdlDefinition = wsdlReference.getDefinition();
            this.wsdlUrl = wsdlReference.getWsdlURL();
        }
        this.messageAdapter = new SOAPMessageAdapter(this.wsdlDefinition, this.serviceName, this.port.getLocalPart());
        this.isInitialized = true;
    }

    public EndpointReference getEndpointReference() {
        return new ClientEndpointReference(this.id);
    }

    public void invoke(PartnerRoleMessageExchange mex) {
        boolean isTwoWay;
        if (!this.isInitialized) {
            this.initialize();
        }
        this.log.debug((Object)("Invoking dispatcher " + this.id));
        boolean bl = isTwoWay = mex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (isTwoWay) {
            Scheduler scheduler = this.executionEnvironment.getScheduler();
            final TwoWayCallable executionCallable = new TwoWayCallable(mex.getMessageExchangeId());
            scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean success) {
                    if (!success) {
                        return;
                    }
                    ExecutorService executorService = WebServiceClient.this.executionEnvironment.getExecutorService();
                    executorService.submit(executionCallable);
                }

                public void beforeCompletion() {
                }
            });
            mex.replyAsync();
        } else {
            ExecutorService executorService = this.executionEnvironment.getExecutorService();
            OneWayCallable executionCallable = new OneWayCallable(mex.getMessageExchangeId());
            executorService.submit(executionCallable);
            mex.replyOneWayOk();
        }
    }

    private void handleFault(PartnerRoleMessageExchange mex, Fault fault, SOAPFault soapFault, Element odeMsgEl) {
        if (fault != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Fault response: faultName=" + fault.getName() + " faultType=" + fault.getMessage().getQName() + "\n" + DOMWriter.printNode(odeMsgEl, true)));
            }
            QName faultType = fault.getMessage().getQName();
            QName faultName = new QName(this.wsdlDefinition.getTargetNamespace(), fault.getName());
            Message response = mex.createMessage(faultType);
            response.setMessage(odeMsgEl);
            mex.replyWithFault(faultName, response);
        } else {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Fault response: faultType=(unknown)");
            }
            mex.replyWithFailure(MessageExchange.FailureType.OTHER, "Unspecified", (Element)soapFault.getDetail());
        }
    }

    private UserTransaction getUserTransaction() throws NamingException {
        InitialContext ctx = new InitialContext();
        UserTransaction tx = (UserTransaction)ctx.lookup("UserTransaction");
        return tx;
    }

    public Element invoke(String operation, Element mesg) throws Exception {
        throw new RuntimeException("Not implemented. Should be removed form interface");
    }

    private synchronized Dispatch getDispatcher(QName portName) {
        if (null == this.dispatcher) {
            this.log.debug((Object)("Creating Dispatcher (" + this.id + ") on " + this.wsdlUrl + ": " + this.serviceName));
            JAXWSInitializer initializer = this.initializeStack(portName);
            Service service = Service.create((URL)this.wsdlUrl, (QName)this.serviceName);
            this.dispatcher = service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
            if (initializer != null) {
                initializer.serviceCreated();
            }
        }
        return this.dispatcher;
    }

    private synchronized JAXWSInitializer initializeStack(QName portName) {
        JAXWSInitializer initializer = null;
        String impl = this.executionEnvironment.getOdeConfig().getProperty(JAXWS_CLIENT_INITIALIZER);
        if (impl != null && impl.trim().length() > 0) {
            try {
                Class<?> cls = Class.forName(impl);
                initializer = (JAXWSInitializer)cls.newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to obtain JAXWS Initializer class '" + impl + "'"), (Throwable)e);
            }
            if (initializer != null) {
                initializer.initializeStack(this.serviceName, portName, this.baseURI);
            }
        } else {
            this.log.debug((Object)"JAXWS Client Initializer not defined");
        }
        return initializer;
    }

    public String toString() {
        return "WebServiceClient {service=" + this.serviceName + ",port=" + this.port + "}";
    }

    public boolean isUDDILookup() {
        return Boolean.valueOf(this.engine.getOdeConfig().getProperty(BPEL_UDDI_LOOKUP, "false"));
    }

    public boolean isWebserviceSecure() {
        return Boolean.valueOf(this.engine.getOdeConfig().getProperty(BPEL_WEBSERVICE_SECURE, "false"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OneWayCallable
    implements Callable<Object> {
        private String mexId;

        public OneWayCallable(String mex) {
            this.mexId = this.mexId;
        }

        @Override
        public Object call() throws Exception {
            return WebServiceClient.this.executionEnvironment.getScheduler().execTransaction((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    PartnerRoleMessageExchange mex = (PartnerRoleMessageExchange)WebServiceClient.this.engine.getBpelServer().getEngine().getMessageExchange(OneWayCallable.this.mexId);
                    try {
                        SOAPMessage soapRequestMessage = MessageFactory.newInstance().createMessage();
                        if (WebServiceClient.this.log.isDebugEnabled()) {
                            WebServiceClient.this.log.debug((Object)("ODE outbound message: \n" + DOMWriter.printNode(mex.getRequest().getMessage(), true)));
                        }
                        WebServiceClient.this.messageAdapter.createSoapRequest(soapRequestMessage, mex.getRequest(), mex.getOperation());
                        if (WebServiceClient.this.log.isDebugEnabled()) {
                            WebServiceClient.this.log.debug((Object)("Riftsaw soap request message: \n" + JavaUtils.getSoapMessageASString(soapRequestMessage)));
                        }
                        Dispatch proxy = WebServiceClient.this.getDispatcher(WebServiceClient.this.port);
                        proxy.invokeOneWay((Object)soapRequestMessage);
                    }
                    catch (Throwable e) {
                        WebServiceClient.this.log.error((Object)"WS invocation failed", e);
                        mex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, e.getMessage(), null);
                    }
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TwoWayCallable
    implements Callable<Object> {
        private String mexId;

        public TwoWayCallable(String mexId) {
            this.mexId = mexId;
        }

        @Override
        public Object call() throws Exception {
            return WebServiceClient.this.executionEnvironment.getScheduler().execTransaction((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    PartnerRoleMessageExchange mex = (PartnerRoleMessageExchange)WebServiceClient.this.engine.getBpelServer().getEngine().getMessageExchange(TwoWayCallable.this.mexId);
                    try {
                        SOAPMessage soapRequestMessage = MessageFactory.newInstance().createMessage();
                        if (WebServiceClient.this.log.isDebugEnabled()) {
                            WebServiceClient.this.log.debug((Object)("ODE outbound message: \n" + DOMWriter.printNode(mex.getRequest().getMessage(), true)));
                        }
                        WebServiceClient.this.messageAdapter.createSoapRequest(soapRequestMessage, mex.getRequest(), mex.getOperation());
                        if (WebServiceClient.this.log.isDebugEnabled()) {
                            WebServiceClient.this.log.debug((Object)("Riftsaw soap request message: \n" + JavaUtils.getSoapMessageASString(soapRequestMessage)));
                        }
                        Dispatch proxy = WebServiceClient.this.getDispatcher(WebServiceClient.this.port);
                        try {
                            SOAPMessage soapResponseMessage = (SOAPMessage)proxy.invoke((Object)soapRequestMessage);
                            Message odeResponse = mex.createMessage(mex.getOperation().getOutput().getMessage().getQName());
                            if (soapResponseMessage.getSOAPBody().hasFault()) {
                                Document odeMsg = DOMUtils.newDocument();
                                Element odeMsgEl = odeMsg.createElementNS(null, "message");
                                odeMsg.appendChild(odeMsgEl);
                                Fault fault = WebServiceClient.this.messageAdapter.parseSoapFault(odeMsgEl, soapResponseMessage, mex.getOperation());
                                WebServiceClient.this.handleFault(mex, fault, soapResponseMessage.getSOAPBody().getFault(), odeMsgEl);
                            } else {
                                WebServiceClient.this.messageAdapter.parseSoapResponse(odeResponse, soapResponseMessage, mex.getOperation());
                                mex.reply(odeResponse);
                            }
                            if (WebServiceClient.this.log.isDebugEnabled()) {
                                WebServiceClient.this.log.debug((Object)("ODE inbound message: \n" + DOMWriter.printNode(odeResponse.getMessage(), true)));
                            }
                        }
                        catch (SOAPFaultException fe) {
                            Document odeMsg = DOMUtils.newDocument();
                            Element odeMsgEl = odeMsg.createElementNS(null, "message");
                            odeMsg.appendChild(odeMsgEl);
                            Fault fault = WebServiceClient.this.messageAdapter.parseSoapFault(odeMsgEl, fe.getFault(), mex.getOperation());
                            WebServiceClient.this.handleFault(mex, fault, fe.getFault(), odeMsgEl);
                        }
                    }
                    catch (Throwable e) {
                        WebServiceClient.this.log.error((Object)"WS invocation failed", e);
                        mex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, e.getMessage(), null);
                    }
                    return null;
                }
            });
        }
    }
}

