/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.util.ArrayList;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;

public class WebMetaDataFactory {
    private String endpointId;
    private String servletClassName = null;
    private String webContext = null;
    private String urlPattern = null;

    public WebMetaDataFactory(String endpointId, String webContext, String urlPattern, String servletClassName) {
        this.endpointId = endpointId;
        this.servletClassName = servletClassName;
        this.webContext = webContext;
        this.urlPattern = urlPattern;
    }

    public JBossWebMetaData createWebMetaData(ClassLoader loader) {
        JBossWebMetaData jbwmd = new JBossWebMetaData();
        this.createWebAppDescriptor(jbwmd);
        this.createJBossWebAppDescriptor(jbwmd);
        return jbwmd;
    }

    private void createWebAppDescriptor(JBossWebMetaData jbwmd) {
        JBossServletsMetaData servlets = jbwmd.getServlets();
        JBossServletMetaData servlet = new JBossServletMetaData();
        servlet.setServletName("Endpoint-" + this.endpointId);
        servlet.setServletClass(this.servletClassName);
        servlets.add((MappableMetaData)servlet);
        ArrayList<ServletMappingMetaData> servletMappings = jbwmd.getServletMappings();
        if (servletMappings == null) {
            servletMappings = new ArrayList<ServletMappingMetaData>();
            jbwmd.setServletMappings(servletMappings);
        }
        ServletMappingMetaData servletMapping = new ServletMappingMetaData();
        servletMapping.setServletName("Endpoint-" + this.endpointId);
        ArrayList<String> urlPatterns = new ArrayList<String>();
        urlPatterns.add(this.urlPattern);
        servletMapping.setUrlPatterns(urlPatterns);
        servletMappings.add(servletMapping);
    }

    private void createJBossWebAppDescriptor(JBossWebMetaData jbwmd) {
        jbwmd.setContextRoot(this.webContext);
    }
}

