/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ServiceEndpointReference
implements EndpointReference {
    private String endpointId;
    private String serviceUrl;
    private String deploymentName;
    private String archiveLocation;

    public ServiceEndpointReference(String endpointId, String location, String deploymentName) {
        this.endpointId = endpointId;
        this.serviceUrl = location;
        this.deploymentName = deploymentName;
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    public Document toXML() {
        Document ret = null;
        try {
            ret = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element elem = ret.createElement("attr");
            elem.setAttribute("location", this.serviceUrl);
            elem.setAttribute("endpointId", this.endpointId);
            elem.setAttribute("deploymentName", this.deploymentName);
            ret.appendChild(elem);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceEndpointReference that = (ServiceEndpointReference)o;
        if (!this.archiveLocation.equals(that.archiveLocation)) {
            return false;
        }
        if (!this.deploymentName.equals(that.deploymentName)) {
            return false;
        }
        if (!this.endpointId.equals(that.endpointId)) {
            return false;
        }
        return this.serviceUrl.equals(that.serviceUrl);
    }

    public int hashCode() {
        int result = this.endpointId.hashCode();
        result = 31 * result + this.serviceUrl.hashCode();
        result = 31 * result + this.deploymentName.hashCode();
        result = 31 * result + this.archiveLocation.hashCode();
        return result;
    }
}

