/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.ws.Provider;
import org.jboss.soa.bpel.runtime.integration.ServerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeploymentBuilder {
    private File war;
    private File webInf;
    private File wsdlDir;
    private DeploymentBuilder instance;
    private ServerConfig serverConfig;

    public DeploymentBuilder(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public DeploymentBuilder setEndpoint(String endpointId) {
        File tmpDir = new File(this.serverConfig.getServerTempDir(), "riftsaw");
        tmpDir.mkdir();
        File fakeWebApp = new File(tmpDir, "riftsaw-" + endpointId + ".war");
        File fakeWebInf = new File(fakeWebApp, "WEB-INF");
        fakeWebInf.mkdirs();
        File fakeWSDLDir = new File(fakeWebInf, "wsdl");
        fakeWSDLDir.mkdirs();
        this.war = fakeWebApp;
        this.webInf = fakeWebInf;
        this.wsdlDir = fakeWSDLDir;
        return this;
    }

    public DeploymentBuilder setWSDL(File wsdl) {
        DeploymentBuilder.copy(wsdl, new File(this.wsdlDir, wsdl.getName()));
        File parent = wsdl.getParentFile();
        assert (parent.isDirectory());
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return true;
            }
        };
        for (File f : parent.listFiles(filter)) {
            if (f.equals(wsdl)) continue;
            DeploymentBuilder.copy(f, new File(this.wsdlDir, f.getName()));
            DeploymentBuilder.copy(f, new File(this.webInf, f.getName()));
        }
        return this;
    }

    public DeploymentBuilder setProvider(Provider<?> provider) {
        File f = new File(this.webInf, "jbossws-cxf.xml");
        if (f.exists()) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(f);
                byte[] b = new byte[fis.available()];
                fis.read(b);
                String str = new String(b);
                fis.close();
                fis = null;
                if (str.indexOf("@provider@") != -1) {
                    fos = new FileOutputStream(f);
                    str = str.replaceAll("@provider@", provider.getClass().getName());
                    fos.write(str.getBytes());
                    fos.flush();
                    fos.close();
                    fos = null;
                } else {
                    System.err.println("jbossws-cxf.xml file does not contain @provider@ field");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy files", e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return this;
    }

    public File build() {
        return this.war;
    }

    public static synchronized void copy(File src, File dest) {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (src.isDirectory()) {
                if (!dest.exists()) {
                    dest.mkdir();
                }
                String[] children = src.list();
                for (int i = 0; i < children.length; ++i) {
                    DeploymentBuilder.copy(new File(src, children[i]), new File(dest, children[i]));
                }
            } else {
                int len;
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy files", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

