/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.jboss.soa.bpel.runtime.ws.JAXWSInitializer;

public class CXFJAXWSInitializer
implements JAXWSInitializer {
    protected final Log log = LogFactory.getLog(this.getClass());

    public void initializeStack(QName serviceName, QName portName, URI baseURI) {
        try {
            SpringBusFactory bf = new SpringBusFactory();
            URLClassLoader urlcl = new URLClassLoader(new URL[]{baseURI.toURL()});
            String filename = "jbossws-cxf-" + portName.getLocalPart() + ".xml";
            URL busFile = urlcl.getResource(filename);
            this.log.debug((Object)("Web Stack initialization file: name=" + filename + " file=" + busFile));
            if (busFile != null) {
                Bus bus = bf.createBus(busFile.toString());
                SpringBusFactory.setThreadDefaultBus((Bus)bus);
                this.log.debug((Object)("Set thread default bus=" + bus));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize WS-Security in stack", (Throwable)e);
        }
    }

    public void serviceCreated() {
        try {
            SpringBusFactory bf = new SpringBusFactory();
            SpringBusFactory.setThreadDefaultBus((Bus)bf.getDefaultBus());
            this.log.debug((Object)"Have reset thread default bus to default");
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to reset default bus", (Throwable)e);
        }
    }
}

