/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.engine.ode;

import java.util.UUID;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.jboss.soa.bpel.runtime.engine.ode.BPELEngineImpl;
import org.jboss.soa.bpel.runtime.engine.ode.PartnerRoleChannelImpl;
import org.jboss.soa.bpel.runtime.engine.ode.UDDIRegistration;
import org.jboss.soa.bpel.runtime.ws.EndpointManager;
import org.jboss.soa.bpel.runtime.ws.EndpointMetaData;
import org.jboss.soa.bpel.runtime.ws.WSDLHelper;
import org.jboss.soa.bpel.runtime.ws.WSDLReference;
import org.jboss.soa.bpel.runtime.ws.WebServiceClient;

public class JAXWSBindingContext
implements BindingContext {
    protected final Log log = LogFactory.getLog(this.getClass());
    private BPELEngineImpl engine;
    private EndpointManager endpointManager;
    private UDDIRegistration uddiRegistration = null;

    public JAXWSBindingContext(BPELEngineImpl server) {
        this.engine = server;
        this.endpointManager = new EndpointManager(this.engine);
    }

    public EndpointReference getEndpoint(QName serviceName, String portName) {
        return this.endpointManager.maintains(serviceName, portName);
    }

    public EndpointReference activateMyRoleEndpoint(QName processId, Endpoint myRoleEndpoint) {
        this.log.info((Object)("Activate my role endpoint: " + myRoleEndpoint));
        EndpointReference ref = this.endpointManager.maintains(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
        if (ref != null && this.endpointManager.isStableInterface()) {
            this.log.warn((Object)("Endpoint does already exist: " + myRoleEndpoint.serviceName + "/" + myRoleEndpoint.portName));
        } else {
            WSDLReference wsdlReference = new WSDLHelper().createWSDLReference(this.engine, processId, myRoleEndpoint.serviceName, myRoleEndpoint.portName);
            try {
                ClassLoader classLoader = JAXWSBindingContext.class.getClassLoader();
                String endpointId = UUID.randomUUID().toString();
                EndpointMetaData endpointMD = new EndpointMetaData(myRoleEndpoint.serviceName, myRoleEndpoint.portName, processId, endpointId);
                ref = this.endpointManager.createEndpoint(endpointMD, wsdlReference, classLoader);
            }
            catch (Throwable e) {
                throw new ContextException("Failed to activate endpoint", e);
            }
        }
        return ref;
    }

    public void deactivateMyRoleEndpoint(Endpoint myRoleEndpoint) {
        this.log.info((Object)("Deactivate my role endpoint: " + myRoleEndpoint));
        EndpointReference ref = this.endpointManager.maintains(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
        if (null == ref) {
            this.log.warn((Object)("Endpoint doesn't exist (Has it been undeployed before?): " + myRoleEndpoint.serviceName + "/" + myRoleEndpoint.portName));
        } else {
            try {
                this.endpointManager.removeEndpoint(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
            }
            catch (Throwable e) {
                throw new ContextException("Failed to deactivate endpoint", e);
            }
        }
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName processId, PortType portType, Endpoint initialPartnerEndpoint) {
        String endpointId = UUID.randomUUID().toString();
        EndpointMetaData endpointMD = new EndpointMetaData(initialPartnerEndpoint.serviceName, initialPartnerEndpoint.portName, processId, endpointId);
        ProcessConf pconf = this.engine._store.getProcessConfiguration(processId);
        try {
            WebServiceClient channel = this.endpointManager.createClient(endpointMD, this.engine, pconf);
            return new PartnerRoleChannelImpl(channel);
        }
        catch (Throwable t) {
            throw new ContextException("Failed to create partner channel", t);
        }
    }

    public long calculateSizeofService(EndpointReference arg0) {
        return 0L;
    }
}

