/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.util.ArrayList;
import java.util.concurrent.SynchronousQueue;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.dao.store.ConfStoreDAOConnection;
import org.apache.ode.dao.store.ConfStoreDAOConnectionFactory;
import org.apache.ode.dao.store.DeploymentUnitDAO;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.ProcessConfImpl;
import org.apache.ode.store.ProcessStoreImpl;
import org.jboss.soa.bpel.deployer.BPELDeployer;
import org.jboss.soa.bpel.deployer.BPELDeploymentListener;
import org.jboss.soa.bpel.deployer.BPELDeploymentUnit;

public class RiftSawProcessStore
extends ProcessStoreImpl
implements BPELDeploymentListener {
    private static final Log __log = LogFactory.getLog(RiftSawProcessStore.class);
    private DeployScheduler m_deployScheduler = new DeployScheduler();

    public RiftSawProcessStore(EndpointReferenceContext eprContext, TransactionManager txm, ConfStoreDAOConnectionFactory cf) {
        super(eprContext, txm, cf);
    }

    public void loadAll() {
        try {
            InitialContext context = new InitialContext();
            BPELDeployer deployer = (BPELDeployer)context.lookup("bpel/Deployer");
            if (deployer != null) {
                deployer.setDeploymentListener((BPELDeploymentListener)this);
            } else {
                __log.error((Object)"Deploy not found in JNDI with name 'bpel/Deployer'");
            }
        }
        catch (Exception e) {
            __log.error((Object)"Failed to obtain BPEL deployer", (Throwable)e);
        }
    }

    public void deploy(BPELDeploymentUnit bdu) {
        __log.debug((Object)("Deploy " + bdu));
        this.m_deployScheduler.add(bdu);
    }

    public void undeploy(BPELDeploymentUnit bdu) {
        __log.debug((Object)("Undeploy " + bdu));
        this.undeploy(bdu.getName());
    }

    public class DeployScheduler
    extends Thread {
        private SynchronousQueue<BPELDeploymentUnit> m_units = new SynchronousQueue();

        public DeployScheduler() {
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.doDeploy(this.m_units.take());
                    }
                }
                catch (Exception e) {
                    __log.error((Object)"Unknown error", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        protected void doDeploy(final BPELDeploymentUnit bdu) {
            __log.debug((Object)("Deploy scheduled: " + bdu.getDeploymentDescriptor().getParentFile()));
            final ArrayList loaded = new ArrayList();
            boolean deploy = (Boolean)RiftSawProcessStore.this.exec((ProcessStoreImpl.Callable)new ProcessStoreImpl.Callable<Boolean>(){

                public Boolean call(ConfStoreDAOConnection conn) {
                    boolean ret;
                    block7: {
                        ret = false;
                        DeploymentUnitDAO dudao = conn.getDeploymentUnit(bdu.getName());
                        if (dudao == null) {
                            return true;
                        }
                        try {
                            String dir = bdu.getDeploymentDescriptor().getParentFile().getCanonicalPath();
                            if (dudao.getDeploymentUnitDir() != null && !dudao.getDeploymentUnitDir().equals(dir)) {
                                __log.debug((Object)("Updating deployunit directory from: " + dudao.getDeploymentUnitDir() + " to: " + dir));
                                dudao.setDeploymentUnitDir(dir);
                            }
                            if (bdu.getLastModified() > dudao.getDeployDate().getTime()) {
                                ret = true;
                                break block7;
                            }
                            __log.debug((Object)("Re-compiling: " + bdu.getDeploymentDescriptor().getParentFile()));
                            DeploymentUnitDir du = new DeploymentUnitDir(bdu.getDeploymentDescriptor().getParentFile());
                            du.setName(bdu.getName());
                            try {
                                du.compile();
                            }
                            catch (CompilationException ce) {
                                String errmsg = "Failed to compile deployment unit '" + bdu.getDeploymentDescriptor().getParentFile() + "'";
                                __log.error((Object)errmsg, (Throwable)ce);
                                throw new ContextException(errmsg, (Throwable)ce);
                            }
                            loaded.addAll(RiftSawProcessStore.this.load(dudao));
                        }
                        catch (Throwable e) {
                            __log.error((Object)"Failed to update deployment unit dir", e);
                        }
                    }
                    return ret;
                }
            });
            if (deploy) {
                __log.debug((Object)("Deploy new version: " + bdu.getDeploymentDescriptor().getParentFile()));
                RiftSawProcessStore.this.deploy(bdu.getDeploymentDescriptor().getParentFile(), true, bdu.getName(), false);
            } else {
                __log.debug((Object)("Trigger Integration Layer to use existing version: " + bdu.getDeploymentDescriptor().getParentFile()));
                for (ProcessConfImpl p : loaded) {
                    try {
                        this.fireStateChange(p.getProcessId(), p.getState(), p.getDeploymentUnit().getName());
                    }
                    catch (Exception except) {
                        __log.error((Object)("Error while activating process: pid=" + p.getProcessId() + " package=" + p.getDeploymentUnit().getName()), (Throwable)except);
                    }
                }
            }
        }

        private void fireStateChange(QName processId, ProcessState state, String duname) {
            switch (state) {
                case ACTIVE: {
                    RiftSawProcessStore.this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.ACTVIATED, processId, duname));
                    break;
                }
                case DISABLED: {
                    RiftSawProcessStore.this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DISABLED, processId, duname));
                    break;
                }
                case RETIRED: {
                    RiftSawProcessStore.this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.RETIRED, processId, duname));
                }
            }
        }

        public void add(BPELDeploymentUnit bdu) {
            try {
                this.m_units.put(bdu);
            }
            catch (Exception e) {
                __log.error((Object)e);
            }
        }
    }
}

