/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;

import java.util.ArrayList;
import java.util.List;

/**
 * Creates an in-memory representation of web meta data.
 * Based on http://anonsvn.jboss.org/repos/jbossas/tags/JBoss_5_1_0_GA/webservices/src/main/org/jboss/wsf/container/jboss50/transport/WebAppGeneratorDeploymentAspect.java
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class WebMetaDataFactory
{
  private String endpointId;
  private String servletClassName = null;
  private String webContext = null;
  private String urlPattern = null;

  public WebMetaDataFactory(String endpointId, String webContext, String urlPattern, String servletClassName)
  {
    this.endpointId = endpointId;
    this.servletClassName = servletClassName;
    this.webContext = webContext;
    this.urlPattern = urlPattern;
  }

  public JBossWebMetaData createWebMetaData(ClassLoader loader)
  {
    JBossWebMetaData jbwmd = new JBossWebMetaData();
    createWebAppDescriptor(jbwmd);
    createJBossWebAppDescriptor(jbwmd);      
    return jbwmd;
  }

  private void createWebAppDescriptor(JBossWebMetaData jbwmd)
  {
    /*
    <servlet>
    <servlet-name>
    <servlet-class>
    </servlet>
    */
    JBossServletsMetaData servlets = jbwmd.getServlets();
    JBossServletMetaData servlet = new JBossServletMetaData();
    servlet.setServletName("Endpoint-"+endpointId);
    servlet.setServletClass(servletClassName);
    servlets.add(servlet);


    /*
    <servlet-mapping>
    <servlet-name>
    <url-pattern>
    </servlet-mapping>
    */
    List<ServletMappingMetaData> servletMappings = jbwmd.getServletMappings();
    if (servletMappings == null)
    {
      servletMappings = new ArrayList<ServletMappingMetaData>();
      jbwmd.setServletMappings(servletMappings);
    }
    ServletMappingMetaData servletMapping = new ServletMappingMetaData();
    servletMapping.setServletName("Endpoint-"+endpointId);
    ArrayList<String> urlPatterns = new ArrayList<String>();
    urlPatterns.add(urlPattern);
    servletMapping.setUrlPatterns(urlPatterns);
    servletMappings.add(servletMapping);

  }

  private void createJBossWebAppDescriptor(JBossWebMetaData jbwmd)
  {
    /* Create a jboss-web
    <jboss-web>
    <security-domain>java:/jaas/cts</security-domain>
    <context-root>/ws/ejbN/</context-root>
    <virtual-host>some.domain.com</virtual-host>
    </jboss-web>
    */

    jbwmd.setContextRoot(webContext);
  }
}
