/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;


import javax.xml.soap.*;
import javax.xml.ws.Provider;

/**
 * CXF requires the JAX-WS implementation class to directly implement the
 * Provider<SOAPMessage>, rather than be derived from a superclass that
 * implements it. Therefore this 'template' web service endpoint class
 * has been created, which will be loaded by javassist and renamed to
 * be the specific endpoint implementation. This is necessary as
 * javassist does not provide a way to set a interface that uses generics.
 *
 * @see org.jboss.soa.bpel.runtime.ws.WebServiceProviderFactory
 *
 */
public class TemplateWebServiceEndpoint extends BaseWebServiceEndpoint implements Provider<SOAPMessage>
{
	// See RIFTSAW-123 for description of issue related to CXF
}
