/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.DOMUtils;
import org.jboss.soa.bpel.runtime.engine.EndpointReference;
import org.jboss.soa.bpel.runtime.engine.PartnerChannel;
import org.jboss.soa.bpel.runtime.engine.ode.ExecutionEnvironment;
import org.jboss.soa.bpel.runtime.ws.ClientEndpointReference;
import org.jboss.soa.bpel.runtime.ws.DOMWriter;
import org.jboss.soa.bpel.runtime.ws.EndpointMetaData;
import org.jboss.soa.bpel.runtime.ws.JavaUtils;
import org.jboss.soa.bpel.runtime.ws.SOAPMessageAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebServiceClient
implements PartnerChannel {
    protected final Log log = LogFactory.getLog(this.getClass());
    private URL wsdlUrl;
    private String id;
    private Dispatch<SOAPMessage> dispatcher = null;
    private EndpointMetaData metaData = null;
    private Definition wsdlDefintion;
    private final QName serviceName;
    private final QName port;
    private SOAPMessageAdapter messageAdapter;
    private ExecutionEnvironment executionEnvironment;

    public WebServiceClient(EndpointMetaData metaData, Definition wsdlDefintion, URL wsdlUrl, ExecutionEnvironment env) {
        this.executionEnvironment = env;
        this.metaData = metaData;
        this.wsdlDefintion = wsdlDefintion;
        this.wsdlUrl = wsdlUrl;
        this.id = metaData.getEndpointId();
        this.serviceName = metaData.getServiceName();
        this.port = new QName(this.serviceName.getNamespaceURI(), metaData.getPortName());
        this.messageAdapter = new SOAPMessageAdapter(this.wsdlDefintion, this.serviceName, this.port.getLocalPart());
    }

    public EndpointReference getEndpointReference() {
        return new ClientEndpointReference(this.id);
    }

    public void invoke(final PartnerRoleMessageExchange mex) {
        boolean isTwoWay;
        this.log.debug((Object)("Invoking dispatcher " + this.id));
        boolean bl = isTwoWay = mex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (isTwoWay) {
            Scheduler scheduler = this.executionEnvironment.getScheduler();
            scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean success) {
                    if (!success) {
                        return;
                    }
                    ExecutorService executorService = WebServiceClient.this.executionEnvironment.getExecutorService();
                    executorService.submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            UserTransaction tx = WebServiceClient.this.getUserTransaction();
                            tx.begin();
                            try {
                                SOAPMessage soapRequestMessage = MessageFactory.newInstance().createMessage();
                                if (WebServiceClient.this.log.isDebugEnabled()) {
                                    WebServiceClient.this.log.debug((Object)("ODE outbound message: \n" + DOMWriter.printNode(mex.getRequest().getMessage(), true)));
                                }
                                WebServiceClient.this.messageAdapter.createSoapRequest(soapRequestMessage, mex.getRequest(), mex.getOperation());
                                if (WebServiceClient.this.log.isDebugEnabled()) {
                                    WebServiceClient.this.log.debug((Object)("Riftsaw soap request message: \n" + JavaUtils.getSoapMessageASString(soapRequestMessage)));
                                }
                                Dispatch proxy = WebServiceClient.this.getDispatcher(WebServiceClient.this.port);
                                try {
                                    SOAPMessage soapResponseMessage = (SOAPMessage)proxy.invoke((Object)soapRequestMessage);
                                    Message odeResponse = mex.createMessage(mex.getOperation().getOutput().getMessage().getQName());
                                    if (soapResponseMessage.getSOAPBody().hasFault()) {
                                        Document odeMsg = DOMUtils.newDocument();
                                        Element odeMsgEl = odeMsg.createElementNS(null, "message");
                                        odeMsg.appendChild(odeMsgEl);
                                        Fault fault = WebServiceClient.this.messageAdapter.parseSoapFault(odeMsgEl, soapResponseMessage, mex.getOperation());
                                        WebServiceClient.this.handleFault(mex, fault, soapResponseMessage.getSOAPBody().getFault(), odeMsgEl);
                                    } else {
                                        WebServiceClient.this.messageAdapter.parseSoapResponse(odeResponse, soapResponseMessage, mex.getOperation());
                                        mex.reply(odeResponse);
                                    }
                                    if (WebServiceClient.this.log.isDebugEnabled()) {
                                        WebServiceClient.this.log.debug((Object)("ODE inbound message: \n" + DOMWriter.printNode(odeResponse.getMessage(), true)));
                                    }
                                }
                                catch (SOAPFaultException fe) {
                                    Document odeMsg = DOMUtils.newDocument();
                                    Element odeMsgEl = odeMsg.createElementNS(null, "message");
                                    odeMsg.appendChild(odeMsgEl);
                                    Fault fault = WebServiceClient.this.messageAdapter.parseSoapFault(odeMsgEl, fe.getFault(), mex.getOperation());
                                    WebServiceClient.this.handleFault(mex, fault, fe.getFault(), odeMsgEl);
                                }
                                tx.commit();
                            }
                            catch (Throwable e) {
                                tx.rollback();
                                WebServiceClient.this.log.error((Object)"WS invocation failed", e);
                                mex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, e.getMessage(), null);
                            }
                            return null;
                        }
                    });
                }

                public void beforeCompletion() {
                }
            });
            mex.replyAsync();
        } else {
            ExecutorService executorService = this.executionEnvironment.getExecutorService();
            executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    UserTransaction tx = WebServiceClient.this.getUserTransaction();
                    tx.begin();
                    try {
                        SOAPMessage soapRequestMessage = MessageFactory.newInstance().createMessage();
                        if (WebServiceClient.this.log.isDebugEnabled()) {
                            WebServiceClient.this.log.debug((Object)("ODE outbound message: \n" + DOMWriter.printNode(mex.getRequest().getMessage(), true)));
                        }
                        WebServiceClient.this.messageAdapter.createSoapRequest(soapRequestMessage, mex.getRequest(), mex.getOperation());
                        if (WebServiceClient.this.log.isDebugEnabled()) {
                            WebServiceClient.this.log.debug((Object)("Riftsaw soap request message: \n" + JavaUtils.getSoapMessageASString(soapRequestMessage)));
                        }
                        Dispatch proxy = WebServiceClient.this.getDispatcher(WebServiceClient.this.port);
                        proxy.invokeOneWay((Object)soapRequestMessage);
                        tx.commit();
                    }
                    catch (Throwable e) {
                        tx.rollback();
                        WebServiceClient.this.log.error((Object)"WS invocation failed", e);
                        mex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, e.getMessage(), null);
                    }
                    return null;
                }
            });
            mex.replyOneWayOk();
        }
    }

    private void handleFault(PartnerRoleMessageExchange mex, Fault fault, SOAPFault soapFault, Element odeMsgEl) {
        if (fault != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Fault response: faultName=" + fault.getName() + " faultType=" + fault.getMessage().getQName() + "\n" + DOMWriter.printNode(odeMsgEl, true)));
            }
            QName faultType = fault.getMessage().getQName();
            QName faultName = new QName(this.wsdlDefintion.getTargetNamespace(), fault.getName());
            Message response = mex.createMessage(faultType);
            response.setMessage(odeMsgEl);
            mex.replyWithFault(faultName, response);
        } else {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Fault response: faultType=(unknown)");
            }
            mex.replyWithFailure(MessageExchange.FailureType.OTHER, "Unspecified", (Element)soapFault.getDetail());
        }
    }

    private UserTransaction getUserTransaction() throws NamingException {
        InitialContext ctx = new InitialContext();
        UserTransaction tx = (UserTransaction)ctx.lookup("UserTransaction");
        return tx;
    }

    public Element invoke(String operation, Element mesg) throws Exception {
        throw new RuntimeException("Not implemented. Should be removed form interface");
    }

    private Dispatch getDispatcher(QName portName) {
        if (null == this.dispatcher) {
            this.log.debug((Object)("Creating Dispatcher (" + this.id + ") on " + this.wsdlUrl + ": " + this.serviceName));
            Service service = Service.create((URL)this.wsdlUrl, (QName)this.serviceName);
            this.dispatcher = service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
        }
        return this.dispatcher;
    }

    public String toString() {
        return "WebServiceClient {service=" + this.serviceName + ",port=" + this.port + "}";
    }
}

