/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Definition wsdl;
    private QName serviceName;
    private String portName;
    private Service serviceDef;
    private Binding binding;
    private Port port;
    private boolean isRPC;
    private SOAPBinding soapBinding;
    private SOAPFactory soapFactory;

    public SOAPMessageAdapter(Definition wsdl, QName serviceName, String portName) {
        this.wsdl = wsdl;
        this.serviceName = serviceName;
        this.portName = portName;
        this.serviceDef = wsdl.getService(serviceName);
        if (this.serviceDef == null) {
            throw new RuntimeException("Service not found " + serviceName);
        }
        this.port = this.serviceDef.getPort(portName);
        if (this.port == null) {
            throw new RuntimeException("Port '" + portName + "' not found on service: " + serviceName);
        }
        this.binding = this.port.getBinding();
        if (this.binding == null) {
            throw new RuntimeException("No binding for port " + portName);
        }
        if (!WsdlUtils.useSOAPBinding((Port)this.port)) {
            throw new RuntimeException("No SOAP binding for port" + portName);
        }
        this.soapBinding = (SOAPBinding)WsdlUtils.getBindingExtension((Port)this.port);
        String style = this.soapBinding.getStyle();
        this.isRPC = style != null && style.equals("rpc");
        try {
            this.soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    public void createSoapRequest(SOAPMessage soapMessage, org.apache.ode.bpel.iapi.Message odeRequestMessage, Operation wsdlOperation) {
        BindingOperation bop = this.binding.getBindingOperation(wsdlOperation.getName(), null, null);
        if (bop == null) {
            throw new RuntimeException("Operation " + wsdlOperation.getName() + "not found on " + this.serviceName + "/" + this.portName);
        }
        BindingInput bi = bop.getBindingInput();
        if (bi == null) {
            throw new RuntimeException("Binding input not found on " + this.serviceName + "/" + this.portName);
        }
        this.createSoapHeaders(soapMessage, SOAPMessageAdapter.getSOAPHeaders((ElementExtensible)bi), wsdlOperation.getInput().getMessage(), odeRequestMessage.getHeaderParts(), odeRequestMessage.getMessage());
        SOAPBody wsdlSoapBody = SOAPMessageAdapter.getSOAPBody((ElementExtensible)bi);
        this.createSoapBody(soapMessage, wsdlSoapBody, wsdlOperation.getInput().getMessage(), odeRequestMessage.getMessage(), wsdlOperation.getName());
    }

    public boolean isRPC() {
        return this.isRPC;
    }

    public void createSoapResponse(SOAPMessage soapMessage, org.apache.ode.bpel.iapi.Message odeResponseMessage, Operation wsdlOperation) {
        BindingOperation bop = this.binding.getBindingOperation(wsdlOperation.getName(), null, null);
        if (bop == null) {
            throw new RuntimeException("Operation " + wsdlOperation.getName() + "not found on " + this.serviceName + "/" + this.portName);
        }
        BindingOutput bo = bop.getBindingOutput();
        if (bo == null) {
            throw new RuntimeException("Binding output not found on " + this.serviceName + "/" + this.portName);
        }
        if (odeResponseMessage.getHeaderParts().size() > 0 || SOAPMessageAdapter.getSOAPHeaders((ElementExtensible)bo).size() > 0) {
            this.createSoapHeaders(soapMessage, SOAPMessageAdapter.getSOAPHeaders((ElementExtensible)bo), wsdlOperation.getOutput().getMessage(), odeResponseMessage.getHeaderParts(), odeResponseMessage.getMessage());
        }
        SOAPBody wsdlSOAPBody = SOAPMessageAdapter.getSOAPBody((ElementExtensible)bo);
        this.createSoapBody(soapMessage, wsdlSOAPBody, wsdlOperation.getOutput().getMessage(), odeResponseMessage.getMessage(), wsdlOperation.getName() + "Response");
    }

    private void createSoapBody(SOAPMessage soapMessage, SOAPBody wsdlSoapBody, Message wsdlMessageDef, Element message, String operationName) {
        try {
            javax.xml.soap.SOAPBody soapBody = soapMessage.getSOAPBody();
            Object partHolder = null;
            partHolder = this.isRPC ? this.soapFactory.createElement(new QName(wsdlSoapBody.getNamespaceURI(), operationName, "odens")) : soapBody;
            List parts = wsdlMessageDef.getOrderedParts(wsdlSoapBody.getParts());
            for (Part part : parts) {
                Element srcPartEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, part.getName()));
                if (srcPartEl == null) {
                    throw new RuntimeException("Part is missing: " + part.getName());
                }
                SOAPElement partElement = this.soapFactory.createElement(srcPartEl);
                if (this.isRPC) {
                    partHolder.addChildElement(partElement);
                    continue;
                }
                Iterator i = partElement.getChildElements();
                while (i.hasNext()) {
                    partHolder.addChildElement((SOAPElement)i.next());
                }
            }
            if (this.isRPC) {
                soapBody.addChildElement((SOAPElement)partHolder);
            }
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to create soap body", e);
        }
    }

    private void createSoapHeaders(SOAPMessage soapMessage, List<javax.wsdl.extensions.soap.SOAPHeader> headers, Message wsdlMessageDef, Map<String, Node> headerParts, Element message) {
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            if (soapHeader == null) {
                soapHeader = soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            for (Node headerNode : headerParts.values()) {
                if (headerNode.getNodeType() == 1) {
                    if (SOAPMessageAdapter.getFirstChildWithName(new QName(headerNode.getNamespaceURI(), headerNode.getLocalName()), (SOAPElement)soapHeader) != null) continue;
                    SOAPElement partElement = this.soapFactory.createElement((Element)headerNode);
                    soapHeader.addChildElement(partElement);
                    continue;
                }
                throw new RuntimeException("SOAP header must be a node_element " + headerNode);
            }
            for (javax.wsdl.extensions.soap.SOAPHeader header : headers) {
                Element headerEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, header.getPart()));
                if (headerEl == null) continue;
                SOAPElement soapHeaderEl = this.soapFactory.createElement(new QName(header.getMessage().getNamespaceURI(), header.getPart(), "odens"));
                NodeList list = headerEl.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    SOAPElement partElement = this.soapFactory.createElement((Element)list.item(i));
                    soapHeaderEl.addChildElement(partElement);
                }
                soapHeader.addChildElement(soapHeaderEl);
            }
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to create soap header", e);
        }
    }

    public void parseSoapResponse(org.apache.ode.bpel.iapi.Message odeMessage, SOAPMessage soapMessage, Operation odeOperation) {
        BindingOperation bop = this.binding.getBindingOperation(odeOperation.getName(), null, null);
        if (bop == null) {
            throw new RuntimeException("Operation " + odeOperation.getName() + "not found on " + this.serviceName + "/" + this.portName);
        }
        BindingOutput bo = bop.getBindingOutput();
        if (bo == null) {
            throw new RuntimeException("Binding output not found on " + this.serviceName + "/" + this.portName);
        }
        this.extractSoapBodyParts(odeMessage, soapMessage, SOAPMessageAdapter.getSOAPBody((ElementExtensible)bo), odeOperation.getOutput().getMessage(), odeOperation.getName() + "Response");
        this.extractSoapHeaderParts(odeMessage, soapMessage, SOAPMessageAdapter.getSOAPHeaders((ElementExtensible)bo), odeOperation.getOutput().getMessage());
    }

    public void parseSoapRequest(org.apache.ode.bpel.iapi.Message odeMessage, SOAPMessage soapMessage, Operation op) {
        BindingOperation bop = this.binding.getBindingOperation(op.getName(), null, null);
        if (bop == null) {
            throw new RuntimeException("Binding operation not found (" + this.serviceName + "/" + this.portName);
        }
        BindingInput bi = bop.getBindingInput();
        if (bi == null) {
            throw new RuntimeException("Binding input not found" + this.serviceName + "/" + this.portName);
        }
        this.extractSoapBodyParts(odeMessage, soapMessage, SOAPMessageAdapter.getSOAPBody((ElementExtensible)bi), op.getInput().getMessage(), op.getName());
        this.extractSoapHeaderParts(odeMessage, soapMessage, SOAPMessageAdapter.getSOAPHeaders((ElementExtensible)bi), op.getInput().getMessage());
    }

    public void createSoapFault(SOAPMessage soapMessage, Element message, QName faultName, Operation op) {
        try {
            Element detail = this.buildSoapDetail(message, faultName, op);
            SOAPFault fault = soapMessage.getSOAPBody().addFault();
            fault.setFaultCode(faultName);
            if (detail != null) {
                fault.addDetail().addChildElement(this.soapFactory.createElement(detail));
            }
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to create fault", e);
        }
    }

    private Element buildSoapDetail(Element message, QName faultName, Operation op) {
        if (faultName.getNamespaceURI() == null) {
            return this.toFaultDetail(faultName, message);
        }
        if (op == null) {
            return this.toFaultDetail(faultName, message);
        }
        Fault f = op.getFault(faultName.getLocalPart());
        if (f == null) {
            return this.toFaultDetail(faultName, message);
        }
        Part p = (Part)f.getMessage().getParts().values().iterator().next();
        if (p == null) {
            return this.toFaultDetail(faultName, message);
        }
        Element partEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, p.getName()));
        if (partEl == null) {
            return this.toFaultDetail(faultName, message);
        }
        Element detail = DOMUtils.findChildByName((Element)partEl, (QName)p.getElementName());
        if (detail == null) {
            return this.toFaultDetail(faultName, message);
        }
        return detail;
    }

    private Element toFaultDetail(QName fault, Element message) {
        if (message == null) {
            return null;
        }
        Element firstPart = DOMUtils.getFirstChildElement((Element)message);
        if (firstPart == null) {
            return null;
        }
        Element detail = DOMUtils.getFirstChildElement((Element)firstPart);
        if (detail == null) {
            return firstPart;
        }
        return detail;
    }

    private void extractSoapHeaderParts(org.apache.ode.bpel.iapi.Message odeMessage, SOAPMessage soapMessage, List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, Message wsdlMessageDef) {
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
                this.handleSoapHeaderPartDef(odeMessage, soapHeader, headerDef, wsdlMessageDef);
            }
            if (soapHeader != null) {
                Iterator headersIter = soapHeader.getChildElements();
                while (headersIter.hasNext()) {
                    Object obj = headersIter.next();
                    if (!(obj instanceof SOAPHeaderElement)) continue;
                    SOAPHeaderElement headerElem = (SOAPHeaderElement)obj;
                    String partName = this.findHeaderPartName(headerDefs, headerElem.getElementQName());
                    Document doc = DOMUtils.newDocument();
                    odeMessage.setHeaderPart(partName, (Element)doc.importNode((Node)headerElem, true));
                }
            }
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to extracts header parts", e);
        }
    }

    private String findHeaderPartName(List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, QName elmtName) {
        for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
            Message hdrMsg = this.wsdl.getMessage(headerDef.getMessage());
            for (Object o : hdrMsg.getParts().values()) {
                Part p = (Part)o;
                if (p.getElementName() == null || !p.getElementName().equals(elmtName)) continue;
                return p.getName();
            }
        }
        return elmtName.getLocalPart();
    }

    private void handleSoapHeaderPartDef(org.apache.ode.bpel.iapi.Message odeMessage, SOAPHeader header, javax.wsdl.extensions.soap.SOAPHeader headerdef, Message msgType) {
        boolean requiredHeader;
        boolean payloadMessageHeader = headerdef.getMessage() == null || headerdef.getMessage().equals(msgType.getQName());
        boolean bl = requiredHeader = payloadMessageHeader || Boolean.TRUE.equals(headerdef.getRequired());
        if (header == null) {
            if (requiredHeader) {
                throw new RuntimeException("Soap Header is missing a required field " + headerdef.getElementType());
            }
            return;
        }
        Message hdrMsg = this.wsdl.getMessage(headerdef.getMessage());
        if (hdrMsg == null) {
            return;
        }
        Part p = hdrMsg.getPart(headerdef.getPart());
        if (p == null || p.getElementName() == null) {
            return;
        }
        SOAPElement headerEl = SOAPMessageAdapter.getFirstChildWithName(p.getElementName(), (SOAPElement)header);
        if (requiredHeader && headerEl == null) {
            throw new RuntimeException("Soap Header is missing a required field " + headerdef.getElementType());
        }
        if (headerEl == null) {
            return;
        }
    }

    private void extractSoapBodyParts(org.apache.ode.bpel.iapi.Message odeMessage, SOAPMessage soapMessage, SOAPBody wsdlSOAPBody, Message wsdlMessageDef, String operationName) {
        try {
            javax.xml.soap.SOAPBody soapBody = soapMessage.getSOAPBody();
            List parts = wsdlMessageDef.getOrderedParts(wsdlSOAPBody.getParts());
            if (this.isRPC) {
                QName rpcWrapQName = new QName(wsdlSOAPBody.getNamespaceURI(), operationName);
                SOAPElement partWrapper = SOAPMessageAdapter.getFirstChildWithName(rpcWrapQName, (SOAPElement)soapBody);
                if (partWrapper == null) {
                    throw new RuntimeException("Expected part wrapper '" + rpcWrapQName + "'missing on service:" + this.serviceName + "/" + this.portName);
                }
                for (Part part : parts) {
                    SOAPElement srcPart = SOAPMessageAdapter.getFirstChildWithName(new QName(null, part.getName()), partWrapper);
                    if (srcPart == null) {
                        throw new RuntimeException("Soap body does not contain required part +" + part.getName());
                    }
                    odeMessage.setPart(srcPart.getLocalName(), (Element)srcPart);
                }
            } else {
                ArrayList<SOAPElement> childElements = new ArrayList<SOAPElement>();
                Iterator children = soapBody.getChildElements();
                while (children.hasNext()) {
                    Node node = (Node)children.next();
                    if (!(node instanceof SOAPElement)) continue;
                    childElements.add((SOAPElement)node);
                }
                Iterator srcParts = childElements.iterator();
                for (Part part : parts) {
                    SOAPElement srcPart = (SOAPElement)srcParts.next();
                    Document doc = DOMUtils.newDocument();
                    Element destPart = doc.createElementNS(null, part.getName());
                    destPart.appendChild(doc.importNode((Node)srcPart, true));
                    odeMessage.setPart(part.getName(), destPart);
                }
            }
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to extract soap body parts", e);
        }
    }

    private static SOAPElement getFirstChildWithName(QName name, SOAPElement parent) {
        SOAPElement match = null;
        Iterator iterator = parent.getChildElements(name);
        while (iterator.hasNext()) {
            match = (SOAPElement)iterator.next();
        }
        return match;
    }

    public static <T> T getFirstExtensibilityElement(ElementExtensible parent, Class<T> cls) {
        Collection ee = CollectionsX.filter((Collection)parent.getExtensibilityElements(), cls);
        return ee.isEmpty() ? null : (T)ee.iterator().next();
    }

    public static SOAPBody getSOAPBody(ElementExtensible ee) {
        return SOAPMessageAdapter.getFirstExtensibilityElement(ee, SOAPBody.class);
    }

    public static List<javax.wsdl.extensions.soap.SOAPHeader> getSOAPHeaders(ElementExtensible eee) {
        return (List)CollectionsX.filter(new ArrayList(), (Collection)eee.getExtensibilityElements(), javax.wsdl.extensions.soap.SOAPHeader.class);
    }

    public Fault parseSoapFault(Element odeMessage, SOAPMessage soapMessage, Operation operation) {
        Fault fdef = null;
        try {
            SOAPFault flt = soapMessage.getSOAPBody().getFault();
            Detail detail = flt.getDetail();
            fdef = this.inferFault(operation, flt);
            if (fdef != null) {
                Part pdef = (Part)fdef.getMessage().getParts().values().iterator().next();
                Element partel = odeMessage.getOwnerDocument().createElementNS(null, pdef.getName());
                odeMessage.appendChild(partel);
                Element childByName = DOMUtils.findChildByName((Element)detail, (QName)pdef.getElementName());
                if (childByName != null) {
                    partel.appendChild(odeMessage.getOwnerDocument().importNode(childByName, true));
                } else {
                    partel.appendChild(odeMessage.getOwnerDocument().importNode((Node)detail, true));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse SOAP Fault", e);
        }
        return fdef;
    }

    public Fault parseSoapFault(Element odeMessage, SOAPFault flt, Operation operation) {
        Fault fault = this.inferFault(operation, flt);
        if (fault != null) {
            Detail detail = flt.getDetail();
            Part pdef = (Part)fault.getMessage().getParts().values().iterator().next();
            Element partel = odeMessage.getOwnerDocument().createElementNS(null, pdef.getName());
            odeMessage.appendChild(partel);
            Element childByName = DOMUtils.findChildByName((Element)detail, (QName)pdef.getElementName());
            if (childByName != null) {
                partel.appendChild(odeMessage.getOwnerDocument().importNode(childByName, true));
            } else {
                partel.appendChild(odeMessage.getOwnerDocument().importNode((Node)detail, true));
            }
        }
        return fault;
    }

    private Fault inferFault(Operation operation, SOAPFault flt) {
        if (!flt.hasDetail()) {
            return null;
        }
        Element element = DOMUtils.getFirstChildElement((Element)flt.getDetail());
        QName elName = new QName(element.getNamespaceURI(), element.getLocalName());
        return WsdlUtils.inferFault((Operation)operation, (QName)elName);
    }
}

