/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.soa.bpel.runtime.integration.ServerConfig;

class DeploymentBuilder {
    private File war;
    private File webInf;
    private File wsdlDir;
    private DeploymentBuilder instance;
    private ServerConfig serverConfig;

    public DeploymentBuilder(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public DeploymentBuilder setEndpoint(String endpointId) {
        File tmpDir = new File(this.serverConfig.getServerTempDir(), "riftsaw");
        tmpDir.mkdir();
        File fakeWebApp = new File(tmpDir, "riftsaw-" + endpointId + ".war");
        File fakeWebInf = new File(fakeWebApp, "WEB-INF");
        fakeWebInf.mkdirs();
        File fakeWSDLDir = new File(fakeWebInf, "wsdl");
        fakeWSDLDir.mkdirs();
        this.war = fakeWebApp;
        this.webInf = fakeWebInf;
        this.wsdlDir = fakeWSDLDir;
        return this;
    }

    public DeploymentBuilder setWSDL(File wsdl) {
        DeploymentBuilder.copy(wsdl, new File(this.wsdlDir, wsdl.getName()));
        File parent = wsdl.getParentFile();
        assert (parent.isDirectory());
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".wsdl") || f.getName().endsWith(".xsd") || f.isDirectory();
            }
        };
        for (File f : parent.listFiles(filter)) {
            if (f.equals(wsdl)) continue;
            DeploymentBuilder.copy(f, new File(this.wsdlDir, f.getName()));
        }
        return this;
    }

    public File build() {
        return this.war;
    }

    public static synchronized void copy(File src, File dest) {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (src.isDirectory()) {
                if (!dest.exists()) {
                    dest.mkdir();
                }
                String[] children = src.list();
                for (int i = 0; i < children.length; ++i) {
                    DeploymentBuilder.copy(new File(src, children[i]), new File(dest, children[i]));
                }
            } else {
                int len;
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy files", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

