/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.db;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.soa.bpel.runtime.db.DatabaseInitializerMBean;
import org.jboss.system.ServiceMBeanSupport;

public class DatabaseInitializer
extends ServiceMBeanSupport
implements DatabaseInitializerMBean {
    private String datasource;
    private String sqlFiles;
    private String existsSql;
    private boolean useEOL;

    public String getExistsSql() {
        return this.existsSql;
    }

    public void setExistsSql(String existsSql) {
        this.existsSql = existsSql;
    }

    public boolean getUseEOL() {
        return this.useEOL;
    }

    public void setUseEOL(boolean useEOL) {
        this.useEOL = useEOL;
    }

    public String getSqlFiles() {
        return this.sqlFiles;
    }

    public void setSqlFiles(String sqlFiles) {
        this.sqlFiles = sqlFiles;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    protected void initDatabase() throws Exception {
        String[] list;
        DataSource ds = (DataSource)new InitialContext().lookup(this.datasource);
        Connection conn = ds.getConnection();
        boolean load = false;
        Statement st = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(this.existsSql.trim());
            rs.close();
        }
        catch (SQLException e) {
            load = true;
        }
        st.close();
        if (!load) {
            this.log.info((Object)(this.datasource + " datasource is already initialized"));
            return;
        }
        this.log.info((Object)("Initializing " + this.datasource + " from listed sql files"));
        for (String sql : list = this.sqlFiles.split(",")) {
            this.executeSql(sql.trim(), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String resource, Connection conn) {
        UserTransaction tx = null;
        try {
            tx = (UserTransaction)new InitialContext().lookup("UserTransaction");
            tx.begin();
            this.log.debug((Object)("Execute SQL from resource: " + resource));
            URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
            this.log.debug((Object)("Execute SQL from resource URL: " + url));
            String sql = this.getStringFromStream(url.openStream());
            sql = sql.replaceAll("(?m)^--([^\n]+)?$", "");
            String[] statements = this.useEOL ? sql.split("[\n;]") : sql.split(";");
            for (String statement : statements) {
                if (statement == null || "".equals(statement.trim())) continue;
                Statement sqlStatement = conn.createStatement();
                try {
                    sqlStatement.executeUpdate(statement);
                }
                finally {
                    sqlStatement.close();
                }
            }
            tx.commit();
        }
        catch (Throwable t) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (SystemException e) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Failed to create database", t);
        }
    }

    protected void startService() throws Exception {
        this.initDatabase();
        super.startService();
    }

    private String getStringFromStream(InputStream is) throws Exception {
        byte[] bytes = DatabaseInitializer.readStream(is);
        return new String(bytes, "UTF-8");
    }

    public static byte[] readStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg passed in method call.");
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int readCount = 0;
        try {
            while ((readCount = stream.read(buffer)) != -1) {
                outBuffer.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading stream.", e);
        }
        return outBuffer.toByteArray();
    }
}

