/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.actions.bpel;

import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.jboss.soa.bpel.runtime.engine.InvocationAdapter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESBInvocationAdapter
implements InvocationAdapter<Element> {
    private String operationName;
    private QName serviceName;
    private String portName;
    private QName faultName;
    private Element requestXML;
    private Element responseXML;

    public ESBInvocationAdapter(String operationName, QName serviceName, String portName) {
        this.operationName = operationName;
        this.serviceName = serviceName;
        this.portName = portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public QName getFaultName() {
        return this.faultName;
    }

    public void setFaultName(QName fname) {
        this.faultName = fname;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setRequestXML(Element requestXML) {
        this.requestXML = requestXML;
    }

    public void parseRequest(MyRoleMessageExchange mex, Message request) {
        if (null == this.requestXML) {
            throw new IllegalArgumentException("request XML not set");
        }
        request.setMessage(this.requestXML);
    }

    public void createResponse(MyRoleMessageExchange mex) {
        this.responseXML = mex.getResponse().getMessage();
    }

    public void createFault(MyRoleMessageExchange mex) {
        this.responseXML = mex.getFaultResponse().getMessage();
        this.faultName = mex.getFault();
    }

    public Element getInvocationResult() {
        return this.responseXML;
    }

    public Element getRequestXML() {
        return this.requestXML;
    }

    public void setResponseXML(Element responseXML) {
        this.responseXML = responseXML;
    }
}

