/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.bpel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.soa.bpel.runtime.engine.BPELEngine;
import org.jboss.soa.bpel.runtime.engine.InvocationAdapter;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.actions.ActionProcessingDetailFaultException;
import org.jboss.soa.esb.actions.bpel.ESBInvocationAdapter;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPELInvoke
extends AbstractActionLifecycle {
    private static final String TOP_LEVEL_ELEMENT_NAME = "message";
    protected static final String REQUEST_PART_NAME = "requestPartName";
    protected static final String RESPONSE_PART_NAME = "responsePartName";
    protected static final String SERVICE = "service";
    protected static final String OPERATION = "operation";
    protected static final String ABORT_ON_FAULT = "abortOnFault";
    protected static final String BODY_FAULT_CODE = "org.jboss.soa.esb.message.fault.detail.code";
    protected static final String BODY_BPEL_FAULT_CODE = "org.jboss.soa.bpel.message.fault.detail.code";
    protected ConfigTree _config;
    private static BPELEngine _bpelEngine;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String NAMESPACE_PREFIX = "{";
    public static final String NAMESPACE_SUFFIX = "}";

    public BPELInvoke(ConfigTree config) {
        this._config = config;
    }

    protected static BPELEngine getBPELEngine() throws Exception {
        if (_bpelEngine == null) {
            InitialContext context = new InitialContext();
            _bpelEngine = (BPELEngine)context.lookup("bpel/Engine");
        }
        return _bpelEngine;
    }

    protected void setBPELEngine(BPELEngine engine) {
        _bpelEngine = engine;
    }

    public Message process(Message message) throws Exception {
        Message ret = null;
        if (this._config.getAttribute(OPERATION) == null) {
            throw new RuntimeException("Property 'operation' has not been specified");
        }
        if (this._config.getAttribute(SERVICE) == null) {
            throw new RuntimeException("Property 'service' has not been specified");
        }
        BPELEngine engine = BPELInvoke.getBPELEngine();
        if (engine == null) {
            throw new RuntimeException("Failed to locate BPEL engine");
        }
        String requestPartName = this._config.getAttribute(REQUEST_PART_NAME);
        this.logger.debug((Object)("Request: " + message));
        boolean f_toText = false;
        Element mesgElem = null;
        Object value = message.getBody().get();
        Node node = null;
        if (value instanceof String) {
            node = BPELInvoke.getNode((String)value);
            f_toText = true;
        } else if (value instanceof Node) {
            node = (Node)value;
        }
        if (node == null) {
            throw new RuntimeException("Failed to obtain DOM representation of message value");
        }
        this.logger.debug((Object)("Node type is: " + node.getNodeType() + " requestPartName=" + requestPartName));
        if (node.getNodeType() == 1 && requestPartName == null) {
            mesgElem = (Element)node;
        } else {
            if (requestPartName == null) {
                throw new RuntimeException("Non-element value can only be used in request if part name specified");
            }
            mesgElem = this.createMessage();
            node = node.cloneNode(true);
            Element partElem = mesgElem.getOwnerDocument().createElement(requestPartName);
            mesgElem.appendChild(partElem);
            node = mesgElem.getOwnerDocument().adoptNode(node);
            partElem.appendChild(node);
        }
        String serviceName = this._config.getAttribute(SERVICE);
        QName qname = new QName(BPELInvoke.getNamespace(serviceName), BPELInvoke.getLocalPart(serviceName));
        this.logger.debug((Object)("Invoking service: " + qname));
        Element resp = null;
        QName faultName = null;
        QName serviceQName = new QName(BPELInvoke.getNamespace(serviceName), BPELInvoke.getLocalPart(serviceName));
        ESBInvocationAdapter invocationContext = new ESBInvocationAdapter(this._config.getAttribute(OPERATION), serviceQName);
        invocationContext.setRequestXML(mesgElem);
        engine.invoke((InvocationAdapter)invocationContext);
        resp = invocationContext.getInvocationResult();
        faultName = invocationContext.getFaultName();
        if (resp != null) {
            ret = MessageFactory.getInstance().getMessage();
            try {
                String defpart = this._config.getAttribute(RESPONSE_PART_NAME);
                Node respNode = null;
                if (defpart != null) {
                    NodeList nl = resp.getChildNodes();
                    for (int i = 0; respNode == null && i < nl.getLength(); ++i) {
                        if (nl.item(i).getNodeType() != 1 || !nl.item(i).getNodeName().equals(defpart)) continue;
                        NodeList subnl = ((Element)nl.item(i)).getChildNodes();
                        if (subnl.getLength() == 1) {
                            respNode = subnl.item(0);
                            continue;
                        }
                        for (int j = 0; respNode != null && j < subnl.getLength(); ++j) {
                            if (subnl.item(j).getNodeType() != 1) continue;
                            respNode = subnl.item(j);
                        }
                    }
                } else {
                    respNode = resp;
                }
                Object respValue = respNode;
                if ((f_toText || faultName != null) && respNode != null) {
                    respValue = BPELInvoke.getText(respNode);
                }
                if (respValue == null) {
                    this.logger.error((Object)("Unable to convert message part '" + (defpart == null ? "<undefined>" : defpart) + "' into a response document"));
                } else {
                    ret.getBody().add(respValue);
                    if (faultName != null) {
                        this.logger.debug((Object)("Fault '" + faultName + "' detected, throwing exception"));
                        ActionProcessingDetailFaultException faultException = new ActionProcessingDetailFaultException(faultName, "Fault '" + faultName + "' occurred when calling service '" + serviceName + "'", respValue.toString());
                        faultException.getFaultMessage().getBody().add(BODY_BPEL_FAULT_CODE, (Object)faultName.toString());
                        throw faultException;
                    }
                }
            }
            catch (ActionProcessingDetailFaultException fault) {
                if (this._config.getAttribute(ABORT_ON_FAULT, "true").equalsIgnoreCase("true")) {
                    this.logger.debug((Object)("Rethrowing BPEL fault: " + (Object)((Object)fault)));
                    throw fault;
                }
                ret = fault.getFaultMessage();
                this.logger.debug((Object)("Returning fault as message: " + ret));
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to parse response '" + resp + "'"), (Throwable)e);
            }
            this.logger.debug((Object)("Response: " + ret));
        }
        return ret;
    }

    protected static String getText(Node node) throws Exception {
        String ret = null;
        try {
            int index;
            ByteArrayOutputStream xmlstr = new ByteArrayOutputStream();
            DOMSource source = new DOMSource();
            source.setNode(node);
            StreamResult result = new StreamResult(xmlstr);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(source, result);
            xmlstr.close();
            ret = new String(xmlstr.toByteArray());
            if (!(node instanceof Document) && (index = ret.indexOf("<?xml")) != -1) {
                index = ret.indexOf("<", 1);
                if (index != -1) {
                    ret = ret.substring(index);
                } else {
                    index = ret.indexOf("?>");
                    if (index != -1) {
                        index += 2;
                        while (index < ret.length() && Character.isWhitespace(ret.charAt(index))) {
                            ++index;
                        }
                        ret = ret.substring(index);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to transform DOM representation into text", e);
        }
        return ret;
    }

    protected Element createMessage() {
        Element ret = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            ret = doc.createElement(TOP_LEVEL_ELEMENT_NAME);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to create message", (Throwable)e);
        }
        return ret;
    }

    protected static Node getNode(String text) throws Exception {
        Node ret = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            DocumentBuilder builder = fact.newDocumentBuilder();
            if (text.trim().length() == 0 || text.charAt(0) != '<') {
                Document doc = builder.newDocument();
                ret = doc.createTextNode(text);
            } else {
                ByteArrayInputStream xmlstr = new ByteArrayInputStream(text.getBytes());
                Document doc = builder.parse(xmlstr);
                ((InputStream)xmlstr).close();
                ret = doc.getDocumentElement();
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to transform text into DOM representation", e);
        }
        return ret;
    }

    protected static String getNamespace(String qname) {
        String ret = null;
        int index = 0;
        if (qname != null && (index = qname.indexOf(NAMESPACE_PREFIX)) != -1) {
            int endindex = qname.indexOf(NAMESPACE_SUFFIX);
            if (endindex == -1) {
                endindex = qname.length();
            }
            ret = qname.substring(index + 1, endindex);
        }
        return ret;
    }

    protected static String getLocalPart(String qname) {
        String ret = null;
        int index = 0;
        ret = qname != null && (index = qname.indexOf(NAMESPACE_SUFFIX)) != -1 ? qname.substring(index + 1) : qname;
        return ret;
    }
}

