/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.bpel;

import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.jboss.soa.bpel.runtime.engine.InvocationAdapter;
import org.w3c.dom.Element;

import javax.xml.namespace.QName;

/**
 * @author Heiko Braun <hbraun@redhat.com>
 */
public class ESBInvocationAdapter implements InvocationAdapter<Element>
{
  private String operationName;
  private QName serviceName;
  private QName faultName;
  private Element requestXML;
  private Element responseXML;

  public ESBInvocationAdapter(String operationName, QName serviceName)
  {
    this.operationName = operationName;
    this.serviceName = serviceName;
  }

  public String getOperationName()
  {
    return operationName;
  }
  
  public QName getFaultName()
  {
	  return faultName;
  }
  
  public void setFaultName(QName fname) {
	  this.faultName = fname;
  }

  public QName getServiceName()
  {
    return serviceName;
  }

  public void setRequestXML(Element requestXML)
  {
    this.requestXML = requestXML;
  }

  public void parseRequest(MyRoleMessageExchange mex, Message request)
  {
    if(null==this.requestXML)
      throw new IllegalArgumentException("request XML not set");
    request.setMessage(this.requestXML);
  }

  public void createResponse(MyRoleMessageExchange mex)
  {
    this.responseXML = mex.getResponse().getMessage();
  }

  public void createFault(MyRoleMessageExchange mex)
  {
    this.responseXML = mex.getFaultResponse().getMessage();
    this.faultName = mex.getFault();
  }

  public Element getInvocationResult()
  {   
    return this.responseXML;
  }

  // test methods
  Element getRequestXML()
  {
    return requestXML;
  }

  void setResponseXML(Element responseXML)
  {
    this.responseXML = responseXML;
  }
}

