/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import org.apache.ode.dao.bpel.FaultDAO;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Entity
@Table(name="BPEL_FAULT")
@NamedQueries(value={@NamedQuery(name="DELETE_FAULTS_BY_IDS", query="delete from FaultDAOImpl as f where f._id in(:ids)")})
public class FaultDAOImpl
implements FaultDAO {
    public static final String DELETE_FAULTS_BY_IDS = "DELETE_FAULTS_BY_IDS";
    @Id
    @Column(name="FAULT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _id;
    @Basic
    @Column(name="NAME")
    private String _name;
    @Basic
    @Column(name="MESSAGE", length=4000)
    private String _explanation;
    @Lob
    @Column(name="DATA")
    private String _data;
    @Basic
    @Column(name="LINE_NUMBER")
    private int _lineNo;
    @Basic
    @Column(name="ACTIVITY_ID")
    private int _activityId;

    public FaultDAOImpl() {
    }

    public FaultDAOImpl(QName faultName, String explanation, int faultLineNo, int activityId, Element faultMessage) {
        this._name = faultName.toString();
        this._explanation = explanation;
        this._lineNo = faultLineNo;
        this._activityId = activityId;
        this._data = faultMessage == null ? null : DOMUtils.domToString((Node)faultMessage);
    }

    public int getActivityId() {
        return this._activityId;
    }

    public Element getData() {
        Element ret = null;
        try {
            ret = this._data == null ? null : DOMUtils.stringToDOM((String)this._data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public String getExplanation() {
        return this._explanation;
    }

    public int getLineNo() {
        return this._lineNo;
    }

    public QName getName() {
        return this._name == null ? null : QName.valueOf(this._name);
    }

    @Deprecated
    public Long get_id() {
        return this._id;
    }

    @Deprecated
    public void set_id(Long id) {
        this._id = id;
    }
}

