/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.scheduler;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.dao.jpa.JpaConnection;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.scheduler.JobDAOImpl;
import org.apache.ode.dao.scheduler.DatabaseException;
import org.apache.ode.dao.scheduler.JobDAO;
import org.apache.ode.dao.scheduler.SchedulerDAOConnection;
import org.apache.ode.utils.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerDAOConnectionImpl
extends JpaConnection
implements SchedulerDAOConnection {
    private static final Log __log = LogFactory.getLog(SchedulerDAOConnectionImpl.class);
    static final ThreadLocal<SchedulerDAOConnectionImpl> _connections = new ThreadLocal();
    private static final int UPDATE_SCHEDULED_SLOTS = 10;

    public SchedulerDAOConnectionImpl(EntityManager mgr, TransactionManager txMgr, JpaOperator operator) {
        super(mgr, txMgr, operator);
    }

    public static ThreadLocal<SchedulerDAOConnectionImpl> getThreadLocal() {
        return _connections;
    }

    public boolean deleteJob(String jobid, String nodeId) throws DatabaseException {
        this._txCtx.begin();
        Query q = this._em.createNamedQuery("deleteJobs");
        q.setParameter("job", (Object)jobid);
        q.setParameter("node", (Object)nodeId);
        boolean ret = q.executeUpdate() == 1;
        this._txCtx.commit();
        return ret;
    }

    public List<JobDAO> dequeueImmediate(String nodeId, long maxtime, int maxjobs) throws DatabaseException {
        this._txCtx.begin();
        Query q = this._em.createNamedQuery("dequeueImmediate");
        q.setParameter("node", (Object)nodeId);
        q.setParameter("time", (Object)maxtime);
        q.setMaxResults(maxjobs);
        List ret = q.getResultList();
        for (JobDAO dao : ret) {
            JobDAOImpl daoImpl = (JobDAOImpl)dao;
            Map detailsExt = daoImpl.getDetails().getDetailsExt();
            if (detailsExt.get("type") != null) {
                daoImpl.setType((String)detailsExt.get("type"));
            }
            if (detailsExt.get("iid") != null) {
                daoImpl.setInstanceId((Long)detailsExt.get("iid"));
            }
            if (detailsExt.get("pid") != null) {
                daoImpl.setProcessId((String)detailsExt.get("pid"));
            }
            if (detailsExt.get("inmem") != null) {
                daoImpl.setInMem((Boolean)detailsExt.get("inmem"));
            }
            if (detailsExt.get("ckey") != null) {
                daoImpl.setCorrelationKeySet((String)detailsExt.get("ckey"));
            }
            if (detailsExt.get("channel") != null) {
                daoImpl.setChannel((String)detailsExt.get("channel"));
            }
            if (detailsExt.get("mexid") != null) {
                daoImpl.setMexId((String)detailsExt.get("mexid"));
            }
            if (detailsExt.get("correlatorId") != null) {
                daoImpl.setCorrelatorId((String)detailsExt.get("correlatorId"));
            }
            if (detailsExt.get("retryCount") == null) continue;
            daoImpl.setRetryCount(Integer.parseInt((String)detailsExt.get("retryCount")));
        }
        int j = 0;
        int updateCount = 0;
        q = this._em.createNamedQuery("updateScheduled");
        for (int updates = 1; updates <= ret.size() / 10 + 1; ++updates) {
            for (int i = 1; i <= 10; ++i) {
                q.setParameter(i, (Object)(j < ret.size() ? ((JobDAO)ret.get(j)).getJobId() : ""));
                ++j;
            }
            updateCount += q.executeUpdate();
        }
        if (updateCount != ret.size()) {
            __log.error((Object)("Updating scheduled jobs failed to update all jobs; expected=" + ret.size() + " actual=" + updateCount));
            return null;
        }
        this._txCtx.commit();
        return ret;
    }

    public List<String> getNodeIds() throws DatabaseException {
        this._txCtx.begin();
        Query q = this._em.createNamedQuery("nodeIds");
        List ret = q.getResultList();
        this._txCtx.commit();
        return ret;
    }

    public boolean insertJob(JobDAO job, String nodeId, boolean loaded) throws DatabaseException {
        this._txCtx.begin();
        JobDAOImpl theJob = (JobDAOImpl)job;
        theJob.setNodeId(nodeId);
        theJob.setScheduled(loaded);
        this._em.persist((Object)theJob);
        this._txCtx.commit();
        return true;
    }

    public int updateAssignToNode(String nodeId, int i, int numNodes, long maxtime) throws DatabaseException {
        this._txCtx.begin();
        Query q = this._em.createNamedQuery("updateAssignToNode");
        q.setParameter("node", (Object)nodeId);
        q.setParameter("numNode", (Object)numNodes);
        q.setParameter("i", (Object)i);
        q.setParameter("maxTime", (Object)maxtime);
        int ret = q.executeUpdate();
        this._txCtx.commit();
        return ret;
    }

    public boolean updateJob(JobDAO job) throws DatabaseException {
        this._txCtx.begin();
        this._em.persist((Object)job);
        this._txCtx.commit();
        return true;
    }

    public int updateReassign(String oldnode, String newnode) throws DatabaseException {
        this._txCtx.begin();
        Query q = this._em.createNamedQuery("updateReassign");
        q.setParameter("newNode", (Object)newnode);
        q.setParameter("oldNode", (Object)oldnode);
        int ret = q.executeUpdate();
        this._txCtx.commit();
        return ret;
    }

    public JobDAO createJob(String jobId, boolean transacted, Scheduler.JobDetails jobDetails, boolean persisted, long scheduledDate) {
        JobDAOImpl theJob = new JobDAOImpl();
        theJob.setJobId(jobId);
        theJob.setTransacted(transacted);
        theJob.setDetails(jobDetails);
        theJob.setPersisted(persisted);
        theJob.setTimestamp(scheduledDate);
        return theJob;
    }

    public JobDAO createJob(boolean transacted, Scheduler.JobDetails jobDetails, boolean persisted, long scheduledDate) {
        return this.createJob(new GUID().toString(), transacted, jobDetails, persisted, scheduledDate);
    }
}

