/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.SystemUtils;

public class OdeConfigProperties {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(OdeConfigProperties.class);
    public static final String PROP_DB_MODE = "db.mode";
    public static final String PROP_DB_EXTERNAL_DS = "db.ext.dataSource";
    public static final String PROP_DB_EMBEDDED_NAME = "db.emb.name";
    public static final String PROP_DB_EMBEDDED_TYPE = "db.emb.type";
    public static final String PROP_DB_EMBEDDED_CREATE = "db.emb.create";
    public static final String PROP_DB_INTERNAL_URL = "db.int.jdbcurl";
    public static final String PROP_DB_INTERNAL_DRIVER = "db.int.driver";
    public static final String PROP_DB_INTERNAL_PASSWORD = "db.int.password";
    public static final String PROP_DB_INTERNAL_USER = "db.int.username";
    public static final String PROP_DB_LOGGING = "db.logging";
    public static final String PROP_TX_FACTORY_CLASS = "tx.factory.class";
    public static final String PROP_POOL_MAX = "db.pool.max";
    public static final String PROP_POOL_MIN = "db.pool.min";
    public static final String PROP_DB_POOL_BLOCKING = "db.pool.blocking";
    public static final String PROP_THREAD_POOL_SIZE = "threads.pool.size";
    public static final String PROP_CONNECTOR_PORT = "jca.port";
    public static final String PROP_CONNECTOR_NAME = "jca.name";
    public static final String PROP_WORKING_DIR = "working.dir";
    public static final String PROP_DEPLOY_DIR = "deploy.dir";
    public static final String PROP_EVENT_LISTENERS = "event.listeners";
    public static final String PROP_MEX_INTERCEPTORS = "mex.interceptors";
    public static final String PROP_MEX_INMEM_TTL = "mex.inmem.ttl";
    public static final String PROP_PROCESS_DEHYDRATION = "process.dehydration";
    public static final String PROP_PROCESS_DEHYDRATION_MAXIMUM_AGE = "process.dehydration.maximum.age";
    public static final String PROP_PROCESS_DEHYDRATION_MAXIMUM_COUNT = "process.dehydration.maximum.count";
    public static final String PROP_PROCESS_HYDRATION_LAZY = "process.hydration.lazy";
    public static final String PROP_PROCESS_HYDRATION_LAZY_MINIMUM_SIZE = "process.hydration.lazy.minimum.size";
    public static final String PROP_PROCESS_HYDRATION_THROTTLED_MAXIMUM_COUNT = "process.hydration.throttled.maximum.count";
    public static final String PROP_PROCESS_HYDRATION_THROTTLED_MAXIMUM_SIZE = "process.hydration.throttled.maximum.size";
    public static final String PROP_PROCESS_INSTANCE_THROTTLED_MAXIMUM_COUNT = "process.instance.throttled.maximum.count";
    public static final String PROP_DAOCF = "dao.factory";
    public static final String PROP_DAOCF_STORE = "dao.factory.store";
    public static final String PROP_DAOCF_SCHEDULER = "dao.factory.scheduler";
    public static final String PROP_CACHE_PROVIDER = "cache.provider";
    public static final String PROP_MIGRATION_TRANSACTION_TIMEOUT = "migration.transaction.timeout";
    public static final String DEFAULT_TX_FACTORY_CLASS_NAME = "org.apache.ode.il.EmbeddedGeronimoFactory";
    public static final String DEFAULT_CACHE_PROVIDER = "org.apache.ode.il.cache.DefaultCacheProvider";
    private File _cfgFile;
    private String _prefix;
    private Properties _props;
    private static String __dbEmbName = "jpadb";
    private static String __daoCfClass = "org.apache.ode.dao.jpa.BPELDAOConnectionFactoryImpl";
    public static String DEFAULT_DB_EMB_NAME = "ode-db";
    public static String DEFAULT_DB_EMB_TYPE = "h2";
    public static String DEFAULT_DAOCF_CLASS = "org.apache.ode.dao.jpa.hibernate.BpelDAOConnectionFactoryImpl";
    public static String DEFAULT_DAOCF_STORE_CLASS = "org.apache.ode.dao.jpa.hibernate.ConfStoreDAOConnectionFactoryImpl";
    public static String DEFAULT_DAOCF_SCHEDULER_CLASS = "org.apache.ode.scheduler.simple.jdbc.SchedulerDAOConnectionFactoryImpl";

    public OdeConfigProperties(File cfgFile, String prefix) {
        this._cfgFile = cfgFile;
        this._prefix = prefix;
        this._props = new Properties();
    }

    public OdeConfigProperties(Properties props, String prefix) {
        this._cfgFile = null;
        this._prefix = prefix;
        this._props = props;
    }

    public File getFile() {
        return this._cfgFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this._cfgFile.exists()) {
            __log.debug((Object)("config file exists: " + this._cfgFile));
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this._cfgFile);
                this._props.load(fis);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        __log.debug((Object)("config file does not exists: " + this._cfgFile));
        throw new FileNotFoundException("" + this._cfgFile);
        for (Object key : this._props.keySet()) {
            String value = (String)this._props.get(key);
            value = SystemUtils.replaceSystemProperties((String)value);
            this._props.put(key, value);
        }
    }

    public String getDbEmbeddedName() {
        return this.getProperty(PROP_DB_EMBEDDED_NAME, __dbEmbName);
    }

    public EmbeddedDbType getDbEmbeddedType() {
        return EmbeddedDbType.valueOf(this.getProperty(PROP_DB_EMBEDDED_TYPE, DEFAULT_DB_EMB_TYPE).trim().toUpperCase());
    }

    public boolean isDbEmbeddedCreate() {
        return Boolean.valueOf(this.getProperty(PROP_DB_EMBEDDED_CREATE, "true"));
    }

    public DatabaseMode getDbMode() {
        return DatabaseMode.valueOf(this.getProperty(PROP_DB_MODE, DatabaseMode.EMBEDDED.toString()).trim().toUpperCase());
    }

    public String getDAOConnectionFactory() {
        return this.getProperty(PROP_DAOCF, DEFAULT_DAOCF_CLASS);
    }

    public String getDAOConfStoreConnectionFactory() {
        return this.getProperty(PROP_DAOCF_STORE, DEFAULT_DAOCF_STORE_CLASS);
    }

    public String getDAOConfScheduleConnectionFactory() {
        return this.getProperty(PROP_DAOCF_SCHEDULER, DEFAULT_DAOCF_SCHEDULER_CLASS);
    }

    public String getCacheProvider() {
        return this.getProperty(PROP_CACHE_PROVIDER, DEFAULT_CACHE_PROVIDER);
    }

    public String getDbDataSource() {
        return this.getProperty(PROP_DB_EXTERNAL_DS, "java:comp/env/jdbc/ode-ds");
    }

    public String getDbIntenralJdbcUrl() {
        return this.getProperty(PROP_DB_INTERNAL_URL, "jdbc:derby://localhost/ode");
    }

    public String getDbInternalMCFClass() {
        return this.getProperty("db.int.mcf");
    }

    public Properties getDbInternalMCFProperties() {
        String prefix = this._prefix + "db.int.mcf.";
        Properties p = new Properties();
        for (Map.Entry<Object, Object> e : this._props.entrySet()) {
            String s = "" + e.getKey();
            if (!s.startsWith(prefix)) continue;
            p.put(s.substring(prefix.length()), e.getValue());
        }
        return p;
    }

    public String getDbInternalJdbcDriverClass() {
        return this.getProperty(PROP_DB_INTERNAL_DRIVER, "org.apache.derby.jdbc.ClientDriver");
    }

    public boolean getPoolBlocking() {
        return Boolean.valueOf(this.getProperty(PROP_DB_POOL_BLOCKING, "false"));
    }

    public int getThreadPoolMaxSize() {
        return Integer.valueOf(this.getProperty(PROP_THREAD_POOL_SIZE, "0"));
    }

    public int getPoolMaxSize() {
        return Integer.valueOf(this.getProperty(PROP_POOL_MAX, "15"));
    }

    public int getPoolMinSize() {
        return Integer.valueOf(this.getProperty(PROP_POOL_MIN, "1"));
    }

    public int getConnectorPort() {
        return Integer.valueOf(this.getProperty(PROP_CONNECTOR_PORT, "2099"));
    }

    public String getConnectorName() {
        return this.getProperty(PROP_CONNECTOR_NAME, "ode");
    }

    public String getWorkingDir() {
        return this.getProperty(PROP_WORKING_DIR);
    }

    public String getDeployDir() {
        return this.getProperty(PROP_DEPLOY_DIR);
    }

    public String getTxFactoryClass() {
        return this.getProperty(PROP_TX_FACTORY_CLASS, DEFAULT_TX_FACTORY_CLASS_NAME);
    }

    public String getEventListeners() {
        return this.getProperty(PROP_EVENT_LISTENERS);
    }

    public String getMessageExchangeInterceptors() {
        return this.getProperty(PROP_MEX_INTERCEPTORS);
    }

    public long getInMemMexTtl() {
        return Long.valueOf(this.getProperty(PROP_MEX_INMEM_TTL, "600000"));
    }

    public boolean isDehydrationEnabled() {
        return Boolean.valueOf(this.getProperty(PROP_PROCESS_DEHYDRATION, "false"));
    }

    public long getDehydrationMaximumAge() {
        return Long.valueOf(this.getProperty(PROP_PROCESS_DEHYDRATION_MAXIMUM_AGE, "1200000"));
    }

    public int getDehydrationMaximumCount() {
        return Integer.valueOf(this.getProperty(PROP_PROCESS_DEHYDRATION_MAXIMUM_COUNT, "1000"));
    }

    public boolean isHydrationLazy() {
        return Boolean.valueOf(this.getProperty(PROP_PROCESS_HYDRATION_LAZY, "true"));
    }

    public int getHydrationLazyMinimumSize() {
        return Integer.valueOf(this.getProperty(PROP_PROCESS_HYDRATION_LAZY_MINIMUM_SIZE, String.valueOf(0)));
    }

    public int getProcessThrottledMaximumCount() {
        return Integer.valueOf(this.getProperty(PROP_PROCESS_HYDRATION_THROTTLED_MAXIMUM_COUNT, String.valueOf(Integer.MAX_VALUE)));
    }

    public int getInstanceThrottledMaximumCount() {
        return Integer.valueOf(this.getProperty(PROP_PROCESS_INSTANCE_THROTTLED_MAXIMUM_COUNT, String.valueOf(Integer.MAX_VALUE)));
    }

    public long getProcessThrottledMaximumSize() {
        return Long.valueOf(this.getProperty(PROP_PROCESS_HYDRATION_THROTTLED_MAXIMUM_SIZE, String.valueOf(Long.MAX_VALUE)));
    }

    public boolean isProcessSizeThrottled() {
        return this.getProcessThrottledMaximumSize() == Long.MAX_VALUE;
    }

    public boolean isDbLoggingEnabled() {
        return Boolean.valueOf(this.getProperty(PROP_DB_LOGGING, "false"));
    }

    public String getProperty(String pname) {
        return this._props.getProperty(this._prefix + pname);
    }

    public String getProperty(String key, String dflt) {
        return this._props.getProperty(this._prefix + key, dflt);
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getDbInternalUserName() {
        return this.getProperty(PROP_DB_INTERNAL_USER);
    }

    public String getDbInternalPassword() {
        return this.getProperty(PROP_DB_INTERNAL_PASSWORD);
    }

    public int getMigrationTransactionTimeout() {
        return Integer.valueOf(this.getProperty(PROP_MIGRATION_TRANSACTION_TIMEOUT, String.valueOf(0)));
    }

    static {
        String odep = System.getProperty("ode.persistence");
        if (odep != null && "hibernate".equalsIgnoreCase(odep)) {
            __log.debug((Object)"Using HIBERNATE due to system property override!");
            __dbEmbName = "hibdb";
            __daoCfClass = "org.apache.ode.daohib.bpel.BpelDAOConnectionFactoryImpl";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EmbeddedDbType {
        H2,
        HSQL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseMode {
        EXTERNAL,
        INTERNAL,
        EMBEDDED;

    }
}

