/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.utils.ISO8601DateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelEventFilter
extends Filter<Criteria>
implements Serializable {
    private static final long serialVersionUID = 9999L;
    private String _type;
    private List<Filter.Restriction<Date>> _tstampRestrictions = new ArrayList<Filter.Restriction<Date>>();
    public int limit;

    public BpelEventFilter(String filter, int limit) {
        this.init(filter);
        this.limit = limit;
    }

    public String getTypeFilter() {
        return this._type;
    }

    public List<Filter.Restriction<Date>> getTimestampFilter() {
        return this._tstampRestrictions;
    }

    @Override
    protected Criteria parseKey(String keyVal) {
        return Criteria.valueOf(keyVal);
    }

    protected Criteria[] getFilterKeys() {
        return Criteria.values();
    }

    @Override
    protected void process(Criteria key, Filter.Restriction<String> rest) {
        key.process(this, rest);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Criteria {
        TYPE{

            @Override
            void process(BpelEventFilter f, Filter.Restriction<String> r) {
                f._type = (String)r.value;
            }
        }
        ,
        TIMESTAMP{

            @Override
            void process(BpelEventFilter f, Filter.Restriction<String> r) {
                try {
                    f._tstampRestrictions.add(new Filter.Restriction<Date>(r.originalKey, r.op, ISO8601DateParser.parse((String)((String)r.value))));
                }
                catch (ParseException e) {
                    String errmsg = Filter.__msgs.msgISODateParseErr(TIMESTAMP.name(), (String)r.value);
                    throw new IllegalArgumentException(errmsg, e);
                }
            }
        };


        abstract void process(BpelEventFilter var1, Filter.Restriction<String> var2);
    }
}

