/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

public class ProcessState {
    public static final short STATE_NEW = 0;
    public static final short STATE_READY = 10;
    public static final short STATE_ACTIVE = 20;
    public static final short STATE_COMPLETED_OK = 30;
    public static final short STATE_COMPLETED_WITH_FAULT = 40;
    public static final short STATE_SUSPENDED = 50;
    public static final short STATE_TERMINATED = 60;
    public static final short[] ALL_STATES = new short[]{0, 10, 20, 30, 40, 50, 60};

    private ProcessState() {
    }

    public static boolean canExecute(short state) {
        return state == 10 || state == 20 || state == 0;
    }

    public static boolean isFinished(short state) {
        return !ProcessState.canExecute(state) && state != 50;
    }

    public static String stateToString(short state) {
        switch (state) {
            case 0: {
                return "New";
            }
            case 10: {
                return "Ready";
            }
            case 20: {
                return "Active";
            }
            case 30: {
                return "Completed Ok";
            }
            case 40: {
                return "Completed Fault";
            }
            case 50: {
                return "Suspended";
            }
            case 60: {
                return "Terminated";
            }
        }
        throw new IllegalStateException("unknown state: " + state);
    }
}

