/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.iapi;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.iapi.ContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Scheduler {
    public void setJobProcessor(JobProcessor var1) throws ContextException;

    public void setPolledRunnableProcesser(JobProcessor var1);

    public String schedulePersistedJob(JobDetails var1, Date var2) throws ContextException;

    public String scheduleMapSerializableRunnable(MapSerializableRunnable var1, Date var2) throws ContextException;

    public String scheduleVolatileJob(boolean var1, JobDetails var2, Date var3) throws ContextException;

    public String scheduleVolatileJob(boolean var1, JobDetails var2) throws ContextException;

    public void cancelJob(String var1) throws ContextException;

    public <T> T execTransaction(Callable<T> var1) throws Exception, ContextException;

    public <T> T execTransaction(Callable<T> var1, int var2) throws Exception, ContextException;

    public void setRollbackOnly() throws Exception;

    public <T> Future<T> execIsolatedTransaction(Callable<T> var1) throws Exception, ContextException;

    public boolean isTransacted();

    public void registerSynchronizer(Synchronizer var1) throws ContextException;

    public void start();

    public void stop();

    public void shutdown();

    public static interface MapSerializableRunnable
    extends Runnable,
    Serializable {
        public void storeToDetails(JobDetails var1);

        public void restoreFromDetails(JobDetails var1);
    }

    public static class JobProcessorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final boolean retry;

        public JobProcessorException(boolean retry) {
            this.retry = retry;
        }

        public JobProcessorException(Throwable cause, boolean retry) {
            super(cause);
            this.retry = retry;
        }
    }

    public static class JobInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String jobName;
        public final int retryCount;
        public final JobDetails jobDetail;

        public JobInfo(String jobName, JobDetails jobDetail, int retryCount) {
            this.jobName = jobName;
            this.jobDetail = jobDetail;
            this.retryCount = retryCount;
        }

        public String toString() {
            return this.jobName + "[" + this.retryCount + "]: " + this.jobDetail;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobDetails {
        public Long instanceId;
        public String mexId;
        public String processId;
        public String type;
        public String channel;
        public String correlatorId;
        public String correlationKeySet;
        public Integer retryCount;
        public Boolean inMem;
        public Map<String, Object> detailsExt = new HashMap<String, Object>();

        public Boolean getInMem() {
            return this.inMem == null ? false : this.inMem;
        }

        public void setInMem(Boolean inMem) {
            this.inMem = inMem;
        }

        public String getMexId() {
            return this.mexId;
        }

        public void setMexId(String mexId) {
            this.mexId = mexId;
        }

        public QName getProcessId() {
            return this.processId == null ? null : QName.valueOf(this.processId);
        }

        public void setProcessId(QName processId) {
            this.processId = "" + processId;
        }

        public JobType getType() {
            return JobType.valueOf(this.type);
        }

        public void setType(JobType type) {
            this.type = type.toString();
        }

        public String getChannel() {
            return this.channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public String getCorrelatorId() {
            return this.correlatorId;
        }

        public void setCorrelatorId(String correlatorId) {
            this.correlatorId = correlatorId;
        }

        public CorrelationKeySet getCorrelationKeySet() {
            return new CorrelationKeySet(this.correlationKeySet);
        }

        public void setCorrelationKeySet(CorrelationKeySet correlationKeySet) {
            this.correlationKeySet = correlationKeySet == null ? null : correlationKeySet.toCanonicalString();
        }

        public Integer getRetryCount() {
            return this.retryCount == null ? 0 : this.retryCount;
        }

        public void setRetryCount(Integer retryCount) {
            this.retryCount = retryCount;
        }

        public Long getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(Long instanceId) {
            this.instanceId = instanceId;
        }

        public Map<String, Object> getDetailsExt() {
            return this.detailsExt;
        }

        public void setDetailsExt(Map<String, Object> detailsExt) {
            this.detailsExt = detailsExt;
        }

        public String toString() {
            return "JobDetails( instanceId: " + this.instanceId + " mexId: " + this.mexId + " processId: " + this.processId + " type: " + this.type + " channel: " + this.channel + " correlatorId: " + this.correlatorId + " correlationKeySet: " + this.correlationKeySet + " retryCount: " + this.retryCount + " inMem: " + this.inMem + " detailsExt: " + this.detailsExt + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobType {
        TIMER,
        RESUME,
        INVOKE_INTERNAL,
        INVOKE_RESPONSE,
        MATCHER,
        INVOKE_CHECK;

    }

    public static interface JobProcessor {
        public void onScheduledJob(JobInfo var1) throws JobProcessorException;
    }

    public static interface Synchronizer {
        public void afterCompletion(boolean var1);

        public void beforeCompletion();
    }
}

