/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import org.apache.commons.lang.StringUtils;
import org.apache.ode.axis2.httpbinding.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;

public class HttpBindingValidator {
    private static final Messages httpMsgs = (Messages)Messages.getMessages(Messages.class);
    private static final org.apache.ode.utils.wsdl.Messages wsdlMsgs = (org.apache.ode.utils.wsdl.Messages)Messages.getMessages(org.apache.ode.utils.wsdl.Messages.class);
    protected Binding binding;

    public HttpBindingValidator(Binding binding) {
        this.binding = binding;
        if (!WsdlUtils.useHTTPBinding((Binding)binding)) {
            throw new IllegalArgumentException(httpMsgs.msgHttpBindingNotUsed(binding));
        }
    }

    public void validate() throws IllegalArgumentException {
        this.validatePort();
    }

    protected void validatePort() {
        for (int i = 0; i < this.binding.getBindingOperations().size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)this.binding.getBindingOperations().get(i);
            this.validateOperation(bindingOperation);
        }
    }

    protected void validateOperation(BindingOperation bindingOperation) {
        String inputContentType;
        String verb = WsdlUtils.resolveVerb((Binding)this.binding, (BindingOperation)bindingOperation);
        if (verb == null) {
            throw new IllegalArgumentException(httpMsgs.msgMissingVerb(this.binding, bindingOperation));
        }
        if (!("GET".equalsIgnoreCase(verb) || "DELETE".equalsIgnoreCase(verb) || "PUT".equalsIgnoreCase(verb) || "POST".equalsIgnoreCase(verb))) {
            throw new IllegalArgumentException(httpMsgs.msgUnsupportedHttpMethod(this.binding, verb));
        }
        BindingOutput output = bindingOperation.getBindingOutput();
        MIMEContent outputContent = WsdlUtils.getMimeContent((List)output.getExtensibilityElements());
        if (outputContent != null && StringUtils.isEmpty((String)outputContent.getType())) {
            throw new IllegalArgumentException(httpMsgs.msgEmptyContentType(this.binding, bindingOperation));
        }
        BindingInput input = bindingOperation.getBindingInput();
        if (WsdlUtils.useMimeMultipartRelated((BindingInput)input)) {
            throw new IllegalArgumentException(httpMsgs.msgMimeMultipartRelatedUnsupported(this.binding, bindingOperation));
        }
        MIMEContent inputContent = WsdlUtils.getMimeContent((List)input.getExtensibilityElements());
        if (inputContent != null && StringUtils.isEmpty((String)(inputContentType = inputContent.getType()))) {
            throw new IllegalArgumentException(httpMsgs.msgEmptyContentType(this.binding, bindingOperation));
        }
        if (WsdlUtils.useUrlReplacement((BindingInput)input)) {
            this.validateUrlReplacement(bindingOperation);
        }
        if ("GET".equalsIgnoreCase(verb) || "DELETE".equalsIgnoreCase(verb)) {
            this.validateGetOrDelete(bindingOperation);
        }
    }

    protected void validateGetOrDelete(BindingOperation bindingOperation) {
        BindingInput input = bindingOperation.getBindingInput();
        if (!WsdlUtils.useUrlEncoded((BindingInput)input) && !WsdlUtils.useUrlReplacement((BindingInput)input)) {
            throw new IllegalArgumentException(httpMsgs.msgOnlySupportsUrlEncodedAndUrlreplacement(this.binding, bindingOperation));
        }
    }

    protected void validateUrlReplacement(BindingOperation bindingOperation) {
        HTTPOperation httpOperation = (HTTPOperation)WsdlUtils.getOperationExtension((BindingOperation)bindingOperation);
        BindingInput input = bindingOperation.getBindingInput();
        Map inputParts = bindingOperation.getOperation().getInput().getMessage().getParts();
        if (WsdlUtils.useUrlReplacement((BindingInput)input)) {
            String locationUri = httpOperation.getLocationURI();
            Set partNames = inputParts.keySet();
            for (String name : partNames) {
                Pattern p = Pattern.compile(".*(\\(" + name + "\\)).*");
                Matcher m = p.matcher(locationUri);
                if (!m.matches() || locationUri.split("(\\(" + name + "\\))", -1).length == 2) continue;
                throw new IllegalArgumentException(httpMsgs.msgInvalidURIPattern(this.binding, bindingOperation, locationUri));
            }
        }
    }
}

