/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;

public class AxisUtils {
    private static final Log log = LogFactory.getLog(AxisUtils.class);

    public static void configureService(AxisService axisService, URL service_file) throws IOException, XMLStreamException, AxisFault {
        AxisUtils.configureService(new ConfigurationContext(axisService.getAxisConfiguration()), axisService, service_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureService(ConfigurationContext configCtx, AxisService axisService, URL service_file) throws IOException, XMLStreamException, AxisFault {
        InputStream ais = service_file.openStream();
        log.debug((Object)("Looking for Axis2 service configuration file: " + service_file));
        if (ais != null) {
            log.debug((Object)("Configuring service " + axisService.getName() + " using: " + service_file));
            try {
                if (configCtx == null) {
                    configCtx = new ConfigurationContext(axisService.getAxisConfiguration());
                }
                ServiceBuilder builder = new ServiceBuilder(ais, configCtx, axisService);
                builder.populateService(builder.buildOM());
            }
            finally {
                ais.close();
            }
            for (int i = 0; i < axisService.getModules().size(); ++i) {
                String moduleRef = (String)axisService.getModules().get(i);
                AxisModule module = axisService.getAxisConfiguration().getModule(moduleRef);
                if (module == null) {
                    throw new AxisFault("Unable to engage module: " + moduleRef);
                }
                axisService.engageModule(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applySecurityPolicy(AxisService service, String policy_file) throws IllegalArgumentException {
        URI policyUri = new File(policy_file).toURI();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Applying security policy: " + policyUri));
        }
        try {
            InputStream policyStream = policyUri.toURL().openStream();
            try {
                Policy policyDoc = PolicyEngine.getPolicy((InputStream)policyStream);
                if (policyDoc == null) {
                    String msg = "Failed to parse policy: " + policy_file + ". Due to Neethi limitations the reason can't be provided. See stacktraces in standard output (not logs)";
                    log.error((Object)msg);
                    throw new IllegalArgumentException(msg);
                }
                service.getPolicyInclude().addPolicyElement(3, policyDoc);
                AxisUtils.engageModules((AxisDescription)service, "rampart", "rahas");
            }
            finally {
                policyStream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while parsing policy: " + policyUri, e);
        }
    }

    public static void engageModules(AxisDescription description, String ... modules) throws AxisFault {
        for (String m : modules) {
            if (description.getAxisConfiguration().getModule(m) != null) {
                if (description.getAxisConfiguration().isEngaged(m) || description.isEngaged(m)) continue;
                description.engageModule(description.getAxisConfiguration().getModule(m));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Module " + m + " is not available."));
        }
    }
}

