/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TwoChannelAxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.axis2.util.SoapMessageConverter;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ODEService {
    private static final Log __log = LogFactory.getLog(ODEService.class);
    private AxisService _axisService;
    private BpelServer _server;
    private TransactionManager _txManager;
    private ProcessConf _pconf;
    private Definition _wsdlDef;
    private QName _serviceName;
    private String _portName;
    private WSAEndpoint _serviceRef;
    private SoapMessageConverter _converter;

    public ODEService(AxisService axisService, ProcessConf pconf, QName serviceName, String portName, BpelServer server, TransactionManager txManager) throws AxisFault {
        this._axisService = axisService;
        this._server = server;
        this._txManager = txManager;
        this._pconf = pconf;
        this._wsdlDef = pconf.getDefinitionForService(serviceName);
        this._serviceName = serviceName;
        this._portName = portName;
        this._serviceRef = EndpointFactory.convertToWSA((MutableEndpoint)ODEService.createServiceRef(ODEService.genEPRfromWSDL(this._wsdlDef, serviceName, portName)));
        this._converter = new SoapMessageConverter(this._wsdlDef, serviceName, portName);
    }

    public String getName() {
        return this._axisService.getName();
    }

    public void onAxisMessageExchange(MessageContext msgContext, MessageContext outMsgContext, SOAPFactory soapFactory) throws AxisFault {
        boolean success = true;
        MyRoleMessageExchange odeMex = null;
        Future responseFuture = null;
        try {
            this._txManager.begin();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Starting transaction.");
            }
            String messageId = new GUID().toString();
            odeMex = this._server.getEngine().createMessageExchange("" + messageId, this._serviceName, msgContext.getAxisOperation().getName().getLocalPart());
            __log.debug((Object)("ODE routed to operation " + odeMex.getOperation() + " from service " + this._serviceName));
            odeMex.setProperty("isTwoWay", Boolean.toString(msgContext.getAxisOperation() instanceof TwoChannelAxisOperation));
            if (odeMex.getOperation() != null) {
                Message odeRequest = odeMex.createMessage(odeMex.getOperation().getInput().getMessage().getQName());
                this._converter.parseSoapRequest(odeRequest, msgContext.getEnvelope(), odeMex.getOperation());
                this.readHeader(msgContext, odeMex);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Invoking ODE using MEX " + odeMex));
                    __log.debug((Object)("Message content:  " + DOMUtils.domToString((Node)odeRequest.getMessage())));
                }
                responseFuture = odeMex.invoke(odeRequest);
                __log.debug((Object)("Commiting ODE MEX " + odeMex));
                try {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)"Commiting transaction.");
                    }
                    this._txManager.commit();
                }
                catch (Exception e) {
                    __log.error((Object)"Commit failed", (Throwable)e);
                    success = false;
                }
            } else {
                success = false;
            }
        }
        catch (Exception e) {
            __log.error((Object)"Exception occured while invoking ODE", (Throwable)e);
            success = false;
            String message = e.getMessage();
            if (message == null) {
                message = "An exception occured while invoking ODE.";
            }
            throw new OdeFault(message, e);
        }
        finally {
            if (!success) {
                if (odeMex != null) {
                    odeMex.release(success);
                }
                try {
                    this._txManager.rollback();
                }
                catch (Exception e) {
                    throw new OdeFault("Rollback failed", e);
                }
            }
        }
        if (odeMex.getOperation().getOutput() != null) {
            try {
                responseFuture.get(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                String errorMsg = "Timeout or execution error when waiting for response to MEX " + odeMex + " " + e.toString();
                __log.error((Object)errorMsg, (Throwable)e);
                throw new OdeFault(errorMsg);
            }
            if (outMsgContext != null) {
                SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
                outMsgContext.setEnvelope(envelope);
                __log.debug((Object)("Handling response for MEX " + odeMex));
                boolean commit = false;
                try {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)"Starting transaction.");
                    }
                    this._txManager.begin();
                }
                catch (Exception ex) {
                    throw new OdeFault("Error starting transaction!", ex);
                }
                try {
                    odeMex = (MyRoleMessageExchange)this._server.getEngine().getMessageExchange(odeMex.getMessageExchangeId());
                    this.onResponse(odeMex, outMsgContext);
                    commit = true;
                }
                catch (AxisFault af) {
                    __log.warn((Object)("MEX produced a fault " + odeMex), (Throwable)af);
                    commit = true;
                    throw af;
                }
                catch (Exception e) {
                    __log.error((Object)("Error processing response for MEX " + odeMex), (Throwable)e);
                    throw new OdeFault("An exception occured when invoking ODE.", e);
                }
                finally {
                    odeMex.release(commit);
                    if (commit) {
                        try {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)"Comitting transaction.");
                            }
                            this._txManager.commit();
                        }
                        catch (Exception e) {
                            throw new OdeFault("Commit failed!", e);
                        }
                    }
                    try {
                        this._txManager.rollback();
                    }
                    catch (Exception ex) {
                        throw new OdeFault("Rollback failed!", ex);
                    }
                }
            }
            if (!success) {
                throw new OdeFault("Message was either unroutable or timed out!");
            }
        } else {
            odeMex.release(true);
        }
    }

    public boolean respondsTo(QName serviceName, QName portTypeName) {
        boolean result = this._serviceName.equals(serviceName);
        result = result && this._wsdlDef.getService(this._serviceName).getPort(this._portName).getBinding().getPortType().getQName().equals(portTypeName);
        return result;
    }

    private long getTimeout() {
        block3: {
            String timeout = (String)this._pconf.getEndpointProperties((EndpointReference)this._serviceRef).get("mex.timeout");
            if (timeout != null) {
                try {
                    return Long.parseLong(timeout);
                }
                catch (NumberFormatException e) {
                    if (!__log.isWarnEnabled()) break block3;
                    __log.warn((Object)("Mal-formatted Property: [mex.timeout=" + timeout + "] Default value (" + 120000 + ") will be used"));
                }
            }
        }
        return 120000L;
    }

    public Options getOptions() {
        return Properties.Axis2.translate((Map)this._pconf.getEndpointProperties((EndpointReference)this._serviceRef));
    }

    private void onResponse(MyRoleMessageExchange mex, MessageContext msgContext) throws AxisFault {
        switch (mex.getStatus()) {
            case FAULT: {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Fault response message: " + mex.getFault()));
                }
                SOAPFault fault = this._converter.createSoapFault(mex.getFaultResponse().getMessage(), mex.getFault(), mex.getOperation());
                msgContext.getEnvelope().getBody().addFault(fault);
                if (!__log.isDebugEnabled()) break;
                __log.debug((Object)("Returning fault: " + msgContext.getEnvelope().toString()));
                break;
            }
            case ASYNC: 
            case RESPONSE: {
                this._converter.createSoapResponse(msgContext, mex.getResponse(), mex.getOperation());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Response message " + msgContext.getEnvelope()));
                }
                this.writeHeader(msgContext, mex);
                break;
            }
            case FAILURE: {
                OdeFault odeFault;
                String beVerbose;
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Failure response message: " + mex.getFault()));
                }
                if ((beVerbose = (String)this._pconf.getEndpointProperties((EndpointReference)this._serviceRef).get("mex.failure.verbose")) == null || Boolean.valueOf(beVerbose).booleanValue()) {
                    odeFault = this._converter.createOdeFault(mex.getFaultExplanation(), mex.getFaultResponse());
                } else {
                    odeFault = new OdeFault("Message exchange failure.");
                    odeFault.setDetail(null);
                    odeFault.setStackTrace(new StackTraceElement[0]);
                }
                throw odeFault;
            }
            default: {
                throw new OdeFault("Received ODE message exchange in unexpected state: " + mex.getStatus());
            }
        }
    }

    private void readHeader(MessageContext msgContext, MyRoleMessageExchange odeMex) {
        WSAEndpoint endpoint;
        Element serviceEpr;
        String correlationId = (String)msgContext.getProperty("JMS_COORELATION_ID");
        if (correlationId != null) {
            odeMex.setProperty("org.apache.ode.bpel.myRoleSessionId", correlationId);
        } else {
            Object otse = msgContext.getProperty("targetSessionEndpoint");
            if (otse != null) {
                serviceEpr = (Element)otse;
                endpoint = new WSAEndpoint();
                endpoint.set((Node)serviceEpr);
                odeMex.setProperty("org.apache.ode.bpel.myRoleSessionId", endpoint.getSessionId());
            }
        }
        Object ocse = msgContext.getProperty("callbackSessionEndpoint");
        if (ocse != null) {
            serviceEpr = (Element)ocse;
            endpoint = new WSAEndpoint();
            endpoint.set((Node)serviceEpr);
            odeMex.setProperty("org.apache.ode.bpel.partnerRoleSessionId", endpoint.getSessionId());
            odeMex.setProperty("org.apache.ode.bpel.partnerRoleEPR", DOMUtils.domToString((Node)serviceEpr));
        }
    }

    private void writeHeader(MessageContext msgContext, MyRoleMessageExchange odeMex) {
        EndpointReference targetEPR = odeMex.getEndpointReference();
        if (targetEPR == null) {
            return;
        }
        if (odeMex.getProperty("org.apache.ode.bpel.myRoleSessionId") != null) {
            WSAEndpoint sessionAwareEndPoint = new WSAEndpoint(this._serviceRef);
            sessionAwareEndPoint.setSessionId(odeMex.getProperty("org.apache.ode.bpel.myRoleSessionId"));
            msgContext.setProperty("callbackSessionEndpoint", (Object)sessionAwareEndPoint);
        }
    }

    public AxisService getAxisService() {
        return this._axisService;
    }

    public EndpointReference getMyServiceRef() {
        return this._serviceRef;
    }

    public static Element genEPRfromWSDL(Definition wsdlDef, QName name, String portName) {
        Port portDef;
        Service serviceDef = wsdlDef.getService(name);
        if (serviceDef != null && (portDef = serviceDef.getPort(portName)) != null) {
            Document doc = DOMUtils.newDocument();
            Element service = doc.createElementNS(Namespaces.WSDL_11, "service");
            service.setAttribute("name", serviceDef.getQName().getLocalPart());
            service.setAttribute("targetNamespace", serviceDef.getQName().getNamespaceURI());
            Element port = doc.createElementNS(Namespaces.WSDL_11, "port");
            service.appendChild(port);
            port.setAttribute("name", portDef.getName());
            port.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bindns", portDef.getBinding().getQName().getNamespaceURI());
            port.setAttribute("bindns:binding", portDef.getName());
            for (Object extElmt : portDef.getExtensibilityElements()) {
                if (extElmt instanceof SOAPAddress) {
                    Element soapAddr = doc.createElementNS(Namespaces.SOAP_NS, "address");
                    port.appendChild(soapAddr);
                    soapAddr.setAttribute("location", ((SOAPAddress)extElmt).getLocationURI());
                    continue;
                }
                if (extElmt instanceof HTTPAddress) {
                    Element httpAddr = doc.createElementNS(Namespaces.HTTP_NS, "address");
                    port.appendChild(httpAddr);
                    httpAddr.setAttribute("location", ((HTTPAddress)extElmt).getLocationURI());
                    continue;
                }
                port.appendChild(doc.importNode(((UnknownExtensibilityElement)extElmt).getElement(), true));
            }
            return service;
        }
        return null;
    }

    public static MutableEndpoint createServiceRef(Element elmt) {
        Document doc = DOMUtils.newDocument();
        QName elQName = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
        if (!EndpointReference.SERVICE_REF_QNAME.equals(elQName)) {
            Element serviceref = doc.createElementNS(EndpointReference.SERVICE_REF_QNAME.getNamespaceURI(), EndpointReference.SERVICE_REF_QNAME.getLocalPart());
            serviceref.appendChild(doc.importNode(elmt, true));
            doc.appendChild(serviceref);
        } else {
            doc.appendChild(doc.importNode(elmt, true));
        }
        return EndpointFactory.createEndpoint((Element)doc.getDocumentElement());
    }
}

