/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import org.jboss.instrument.classloading.JBoss5LoadTimeWeaver;
import org.jboss.instrument.classloading.JBossModulesLoadTimeWeaver;
import org.jboss.spring.util.Version;
import org.jboss.spring.util.VersionProvider;
import org.springframework.instrument.classloading.LoadTimeWeaver;

public class JBossLoadTimeWeaver
implements LoadTimeWeaver {
    private final LoadTimeWeaver delegateLoadTimeWeaver;

    public JBossLoadTimeWeaver() {
        if (VersionProvider.VERSION.compareTo((Enum)Version.AS_7) >= 0) {
            this.delegateLoadTimeWeaver = new JBossModulesLoadTimeWeaver();
        } else if (Version.AS_5_OR_6.equals((Object)VersionProvider.VERSION)) {
            this.delegateLoadTimeWeaver = new JBoss5LoadTimeWeaver();
        } else {
            throw new IllegalStateException("Cannot initialize delegate: JBoss version not recognized");
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.delegateLoadTimeWeaver.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.delegateLoadTimeWeaver.getInstrumentableClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.delegateLoadTimeWeaver.getThrowawayClassLoader();
    }
}

