/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Method;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.instrument.classloading.JBoss50ClassLoader;
import org.jboss.instrument.classloading.JBoss51ClassLoader;
import org.jboss.instrument.classloading.JBoss5ClassLoader;
import org.jboss.instrument.classloading.ReflectionHelper;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JBoss5LoadTimeWeaver
extends ReflectionHelper
implements LoadTimeWeaver {
    private JBoss5ClassLoader classLoader;

    public JBoss5LoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public JBoss5LoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        BaseClassLoader bcl = this.determineClassLoader(classLoader);
        if (bcl == null) {
            throw new IllegalArgumentException(classLoader + " and its parents are not suitable ClassLoaders: " + "An [" + BaseClassLoader.class.getName() + "] implementation is required.");
        }
        this.classLoader = this.createClassLoaderWrapper(bcl);
    }

    protected JBoss5ClassLoader createClassLoaderWrapper(BaseClassLoader bcl) {
        String tag;
        Method getRevision;
        Object version;
        int versionNumber = 0;
        try {
            Class versionClass = bcl.loadClass("org.jboss.Version");
            Method getInstance = JBoss5LoadTimeWeaver.getMethod(versionClass, "getInstance");
            version = getInstance.invoke(null, new Object[0]);
            Method getMajor = JBoss5LoadTimeWeaver.getMethod(versionClass, "getMajor");
            versionNumber += 100 * JBoss5LoadTimeWeaver.invokeMethod(getMajor, version, Integer.class);
            Method getMinor = JBoss5LoadTimeWeaver.getMethod(versionClass, "getMinor");
            versionNumber += 10 * JBoss5LoadTimeWeaver.invokeMethod(getMinor, version, Integer.class);
            getRevision = JBoss5LoadTimeWeaver.getMethod(versionClass, "getRevision");
            Method getTag = JBoss5LoadTimeWeaver.getMethod(versionClass, "getTag");
            tag = JBoss5LoadTimeWeaver.invokeMethod(getTag, version, String.class);
        }
        catch (Exception e) {
            this.log.warn((Object)("Exception creating JBoss5 CL wrapper: " + e + ", falling back to JBoss50ClassLoader wrapper."));
            return new JBoss50ClassLoader(bcl);
        }
        if ((versionNumber += JBoss5LoadTimeWeaver.invokeMethod(getRevision, version, Integer.class).intValue()) < 500) {
            throw new IllegalArgumentException("JBoss5LoadTimeWeaver can only be used on new JBoss Microcontainer ClassLoader.");
        }
        if (versionNumber <= 501 || versionNumber == 510 && "Beta1".equals(tag)) {
            return new JBoss50ClassLoader(bcl);
        }
        return new JBoss51ClassLoader(bcl);
    }

    private BaseClassLoader determineClassLoader(ClassLoader classLoader) {
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            if (!(cl instanceof BaseClassLoader)) continue;
            return (BaseClassLoader)cl;
        }
        return null;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader.getInternalClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.classLoader.getThrowawayClassLoader();
    }
}

