/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.spring.vfs.VFSResource;
import org.jboss.spring.vfs.VFSUtil;
import org.springframework.core.io.Resource;
import org.springframework.util.PathMatcher;

public class VFSResourcePatternResolvingHelper {
    private static Logger log = Logger.getLogger(VFSResourcePatternResolvingHelper.class);

    public static Resource[] locateResources(String locationPattern, String rootDirPath, ClassLoader classLoader, PathMatcher pathMatcher, boolean oneMatchingRootOnly) throws IOException {
        String subPattern = locationPattern.substring(rootDirPath.length());
        if (rootDirPath.startsWith("/")) {
            rootDirPath = rootDirPath.substring(1);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Enumeration<URL> urls = classLoader.getResources(rootDirPath);
        if (!oneMatchingRootOnly) {
            while (urls.hasMoreElements()) {
                resources.addAll(VFSResourcePatternResolvingHelper.getVFSResources(urls.nextElement(), subPattern, pathMatcher));
            }
        } else {
            resources.addAll(VFSResourcePatternResolvingHelper.getVFSResources(classLoader.getResource(rootDirPath), subPattern, pathMatcher));
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public static Set<Resource> getVFSResources(URL rootURL, String subPattern, PathMatcher pathMatcher) throws IOException {
        log.debug((Object)("Scanning url: " + rootURL + ", sub-pattern: " + subPattern));
        Object root = VFSResource.getChild(rootURL);
        String pathName = (String)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_GET_PATH_NAME, root, new Object[0]);
        PatternVirtualFileVisitorInvocationHandler visitorInvocationHandler = new PatternVirtualFileVisitorInvocationHandler(pathName, subPattern, pathMatcher);
        Object visitor = Proxy.newProxyInstance(VFSUtil.VIRTUAL_FILE_VISITOR_CLASS.getClassLoader(), new Class[]{VFSUtil.VIRTUAL_FILE_VISITOR_CLASS}, (InvocationHandler)visitorInvocationHandler);
        VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_VISIT, root, visitor);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found resources: " + visitor));
        }
        return visitorInvocationHandler.getResources();
    }

    protected static class PatternVirtualFileVisitorInvocationHandler
    implements InvocationHandler {
        private final String subPattern;
        private final Set<Resource> resources = new HashSet<Resource>();
        private final PathMatcher pathMatcher;
        private final String rootPath;

        private PatternVirtualFileVisitorInvocationHandler(String rootPath, String subPattern, PathMatcher pathMatcher) {
            this.subPattern = subPattern;
            this.pathMatcher = pathMatcher;
            this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (Object.class.equals(method.getDeclaringClass())) {
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if ("toString".equals(methodName)) {
                    return this.toString();
                }
            } else {
                if ("getAttributes".equals(methodName)) {
                    return this.getAttributes();
                }
                if ("visit".equals(methodName)) {
                    this.visit(args[0]);
                    return null;
                }
                if ("toString".equals(methodName)) {
                    return this.toString();
                }
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        private Object getAttributes() throws IllegalAccessException {
            return VFSUtil.VISITOR_ATTRIBUTES_FIELD_RECURSE.get(null);
        }

        private void visit(Object vf) throws IOException {
            if (this.pathMatcher.match(this.subPattern, ((String)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_GET_PATH_NAME, vf, new Object[0])).substring(this.rootPath.length()))) {
                this.resources.add((Resource)new VFSResource(vf));
            }
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sub-pattern: ").append(this.subPattern);
            buffer.append(", resources: ").append(this.resources);
            return buffer.toString();
        }
    }
}

