/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import org.jboss.logging.Logger;
import org.springframework.core.NestedIOException;
import org.springframework.util.ReflectionUtils;

public class VFSUtil {
    private static final Logger logger = Logger.getLogger(VFSUtil.class);
    protected static final String VFS2_PACKAGE_NAME = "org.jboss.virtual";
    protected static final String VFS3_PACKAGE_NAME = "org.jboss.vfs";
    private static String[] VFS_PACKAGE_NAME_CANDIDATES = new String[]{"org.jboss.virtual", "org.jboss.vfs"};
    public static Class<?> VFS_CLASS = null;
    public static Method VFS_METHOD_GET_ROOT_URL = null;
    public static Method VFS_METHOD_GET_ROOT_URI = null;
    public static Class<?> VIRTUAL_FILE_CLASS = null;
    public static Method VIRTUAL_FILE_METHOD_EXISTS = null;
    public static Method VIRTUAL_FILE_METHOD_GET_SIZE;
    public static Method VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED;
    public static Method VIRTUAL_FILE_METHOD_GET_CHILD;
    public static Method VIRTUAL_FILE_METHOD_GET_INPUT_STREAM;
    public static Method VIRTUAL_FILE_METHOD_TO_URL;
    public static Method VIRTUAL_FILE_METHOD_TO_URI;
    public static Method VIRTUAL_FILE_METHOD_GET_NAME;
    public static Method VIRTUAL_FILE_METHOD_GET_PATH_NAME;
    public static Method VIRTUAL_FILE_METHOD_VISIT;
    public static Class<?> VFS_UTILS_CLASS;
    public static Method VFS_UTILS_METHOD_IS_NESTED_FILE;
    public static Method VFS_UTILS_METHOD_GET_COMPATIBLE_URI;
    public static Class<?> VIRTUAL_FILE_VISITOR_CLASS;
    public static Class<?> VISITOR_ATTRIBUTES_CLASS;
    public static Field VISITOR_ATTRIBUTES_FIELD_RECURSE;
    public static String vfsPackageName;

    public static <T, E extends Exception> T invokeMethodWithExpectedExceptionType(Method method, Object target, Class<E> expectedExceptionType, Object ... args) throws E {
        try {
            return (T)method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
        }
        catch (InvocationTargetException ex) {
            if (expectedExceptionType.isAssignableFrom(ex.getTargetException().getClass())) {
                throw (Exception)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static <T> T invokeVfsMethod(Method method, Object target, Object ... arguments) throws IOException {
        return VFSUtil.invokeMethodWithExpectedExceptionType(method, target, IOException.class, arguments);
    }

    public static File getPhysicalFile(Object virtualFile) throws IOException {
        if (VFS2_PACKAGE_NAME.equals(vfsPackageName)) {
            if (((Boolean)VFSUtil.invokeVfsMethod(VFS_UTILS_METHOD_IS_NESTED_FILE, null, virtualFile)).booleanValue()) {
                throw new IOException("File resolution not supported for nested resource: " + virtualFile);
            }
            try {
                return new File((URI)VFSUtil.invokeVfsMethod(VFS_UTILS_METHOD_GET_COMPATIBLE_URI, null, virtualFile));
            }
            catch (Exception ex) {
                throw new NestedIOException("Failed to obtain File reference for " + virtualFile, (Throwable)ex);
            }
        }
        return (File)VFSUtil.invokeVfsMethod(ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"getPhysicalFile"), virtualFile, new Object[0]);
    }

    static {
        VFS_UTILS_CLASS = null;
        VFS_UTILS_METHOD_IS_NESTED_FILE = null;
        VFS_UTILS_METHOD_GET_COMPATIBLE_URI = null;
        VIRTUAL_FILE_VISITOR_CLASS = null;
        VISITOR_ATTRIBUTES_CLASS = null;
        VISITOR_ATTRIBUTES_FIELD_RECURSE = null;
        vfsPackageName = null;
        ClassLoader loader = VFSUtil.class.getClassLoader();
        for (String vfsPackageNameCandidate : VFS_PACKAGE_NAME_CANDIDATES) {
            try {
                VFS_CLASS = loader.loadClass(vfsPackageNameCandidate + "." + "VFS");
                vfsPackageName = vfsPackageNameCandidate;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (vfsPackageName == null) {
            throw new IllegalStateException("No known VFS package found while trying to process VFS resource");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("VFS package name is:" + vfsPackageName));
        }
        try {
            if (VFS2_PACKAGE_NAME.equals(vfsPackageName)) {
                VFS_METHOD_GET_ROOT_URL = ReflectionUtils.findMethod(VFS_CLASS, (String)"getRoot", (Class[])new Class[]{URL.class});
                VFS_METHOD_GET_ROOT_URI = ReflectionUtils.findMethod(VFS_CLASS, (String)"getRoot", (Class[])new Class[]{URI.class});
            } else {
                VFS_METHOD_GET_ROOT_URL = ReflectionUtils.findMethod(VFS_CLASS, (String)"getChild", (Class[])new Class[]{URL.class});
                VFS_METHOD_GET_ROOT_URI = ReflectionUtils.findMethod(VFS_CLASS, (String)"getChild", (Class[])new Class[]{URI.class});
            }
            VIRTUAL_FILE_CLASS = loader.loadClass(vfsPackageName + ".VirtualFile");
            VIRTUAL_FILE_METHOD_EXISTS = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"exists");
            VIRTUAL_FILE_METHOD_GET_SIZE = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"getSize");
            VIRTUAL_FILE_METHOD_GET_INPUT_STREAM = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"openStream");
            VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"getLastModified");
            VIRTUAL_FILE_METHOD_TO_URI = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"toURI");
            VIRTUAL_FILE_METHOD_TO_URL = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"toURL");
            VIRTUAL_FILE_METHOD_GET_NAME = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"getName");
            VIRTUAL_FILE_METHOD_GET_PATH_NAME = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"getPathName");
            VIRTUAL_FILE_METHOD_GET_CHILD = VFS2_PACKAGE_NAME.equals(vfsPackageName) ? ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"findChild", (Class[])new Class[]{String.class}) : ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"getChild", (Class[])new Class[]{String.class});
            VFS_UTILS_CLASS = loader.loadClass(vfsPackageName + ".VFSUtils");
            VFS_UTILS_METHOD_GET_COMPATIBLE_URI = ReflectionUtils.findMethod(VFS_UTILS_CLASS, (String)"getCompatibleURI", (Class[])new Class[]{VIRTUAL_FILE_CLASS});
            VFS_UTILS_METHOD_IS_NESTED_FILE = ReflectionUtils.findMethod(VFS_UTILS_CLASS, (String)"isNestedFile", (Class[])new Class[]{VIRTUAL_FILE_CLASS});
            VIRTUAL_FILE_VISITOR_CLASS = loader.loadClass(vfsPackageName + ".VirtualFileVisitor");
            VIRTUAL_FILE_METHOD_VISIT = ReflectionUtils.findMethod(VIRTUAL_FILE_CLASS, (String)"visit", (Class[])new Class[]{VIRTUAL_FILE_VISITOR_CLASS});
            VISITOR_ATTRIBUTES_CLASS = loader.loadClass(vfsPackageName + ".VisitorAttributes");
            VISITOR_ATTRIBUTES_FIELD_RECURSE = ReflectionUtils.findField(VISITOR_ATTRIBUTES_CLASS, (String)"RECURSE");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("A VFS class hasn't been found, although others exist:", e);
        }
    }
}

