/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class VFSResource
extends AbstractResource {
    private VirtualFile file;

    public VFSResource(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    public VFSResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            this.file = VFS.getChild((URL)url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot retrieve file from URL: ", e);
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isReadable() {
        return this.file.getSize() > 0L;
    }

    public long lastModified() {
        return this.file.getLastModified();
    }

    public URL getURL() throws IOException {
        return this.file.toURL();
    }

    public URI getURI() throws IOException {
        try {
            return this.file.toURI();
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public File getFile() throws IOException {
        return this.file.getPhysicalFile();
    }

    public Resource createRelative(String relativePath) throws IOException {
        if (relativePath.startsWith(".") || relativePath.indexOf("/") == -1) {
            return new VFSResource(VFSResource.getChild(new URL(this.getURL(), relativePath)));
        }
        return new VFSResource(this.file.getChild(relativePath));
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getDescription() {
        return this.file.toString();
    }

    public InputStream getInputStream() throws IOException {
        return this.file.openStream();
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object other) {
        if (other instanceof VFSResource) {
            return this.file.equals((Object)((VFSResource)((Object)other)).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    static VirtualFile getChild(URL url) throws IOException {
        try {
            return VFS.getChild((URL)url);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }
}

