/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.IOException;
import java.net.URL;
import org.jboss.spring.vfs.VFSResource;
import org.jboss.spring.vfs.VFSResourcePatternResolvingHelper;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class VFSServletContextResourcePatternResolver
extends ServletContextResourcePatternResolver {
    public VFSServletContextResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("classpath*:")) {
            locationPattern = locationPattern.substring("classpath*:".length());
            String rootDirPath = this.determineRootDir(locationPattern);
            return VFSResourcePatternResolvingHelper.locateResources(locationPattern, rootDirPath, this.getClassLoader(), this.getPathMatcher(), false);
        }
        if (locationPattern.startsWith("classpath:")) {
            locationPattern = locationPattern.substring("classpath:".length());
            String rootDirPath = this.determineRootDir(locationPattern);
            return VFSResourcePatternResolvingHelper.locateResources(locationPattern, rootDirPath, this.getClassLoader(), this.getPathMatcher(), true);
        }
        return super.findPathMatchingResources(locationPattern);
    }

    protected Resource convertClassLoaderURL(URL url) {
        try {
            VirtualFile file = VFS.getChild((URL)url);
            return new VFSResource(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

