/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.spring.vfs.VFSResource;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.springframework.core.io.Resource;
import org.springframework.util.PathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSResourcePatternResolvingHelper {
    private static Logger log = Logger.getLogger(VFSResourcePatternResolvingHelper.class);

    public static Resource[] locateResources(String locationPattern, String rootDirPath, ClassLoader classLoader, PathMatcher pathMatcher, boolean oneMatchingRootOnly) throws IOException {
        String subPattern = locationPattern.substring(rootDirPath.length());
        if (rootDirPath.startsWith("/")) {
            rootDirPath = rootDirPath.substring(1);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Enumeration<URL> urls = classLoader.getResources(rootDirPath);
        if (!oneMatchingRootOnly) {
            while (urls.hasMoreElements()) {
                resources.addAll(VFSResourcePatternResolvingHelper.getVFSResources(urls.nextElement(), subPattern, pathMatcher));
            }
        } else {
            resources.addAll(VFSResourcePatternResolvingHelper.getVFSResources(classLoader.getResource(rootDirPath), subPattern, pathMatcher));
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public static Set<Resource> getVFSResources(URL rootURL, String subPattern, PathMatcher pathMatcher) throws IOException {
        log.debug((Object)("Scanning url: " + rootURL + ", sub-pattern: " + subPattern));
        VirtualFile root = VFSResource.getChild(rootURL);
        PatternVirtualFileVisitor visitor = new PatternVirtualFileVisitor(root.getPathName(), subPattern, pathMatcher);
        root.visit((VirtualFileVisitor)visitor);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found resources: " + visitor));
        }
        return visitor.getResources();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PatternVirtualFileVisitor
    implements VirtualFileVisitor {
        private final String subPattern;
        private final Set<Resource> resources = new HashSet<Resource>();
        private final PathMatcher pathMatcher;
        private final String rootPath;

        private PatternVirtualFileVisitor(String rootPath, String subPattern, PathMatcher pathMatcher) {
            this.subPattern = subPattern;
            this.pathMatcher = pathMatcher;
            this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        public VisitorAttributes getAttributes() {
            return VisitorAttributes.RECURSE_LEAVES_ONLY;
        }

        public void visit(VirtualFile vf) {
            if (this.pathMatcher.match(this.subPattern, vf.getPathName().substring(this.rootPath.length()))) {
                this.resources.add((Resource)new VFSResource(vf));
            }
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sub-pattern: ").append(this.subPattern);
            buffer.append(", resources: ").append(this.resources);
            return buffer.toString();
        }
    }
}

