/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.IOException;
import org.jboss.spring.vfs.VFSResourcePatternResolvingHelper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class VFSResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    public VFSResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("classpath*:")) {
            locationPattern = locationPattern.substring("classpath*:".length());
            String rootDirPath = this.determineRootDir(locationPattern);
            return VFSResourcePatternResolvingHelper.locateResources(locationPattern, rootDirPath, this.getClassLoader(), this.getPathMatcher(), false);
        }
        if (locationPattern.startsWith("classpath:")) {
            locationPattern = locationPattern.substring("classpath:".length());
            String rootDirPath = this.determineRootDir(locationPattern);
            return VFSResourcePatternResolvingHelper.locateResources(locationPattern, rootDirPath, this.getClassLoader(), this.getPathMatcher(), true);
        }
        return super.findPathMatchingResources(locationPattern);
    }
}

