/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers.as7;

import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.spring.deployers.as7.SpringDescriptionProviders;
import org.jboss.spring.deployers.as7.SpringSubsystemAdd;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SpringExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.snowdrop");
    public static final String SUBSYSTEM_NAME = "spring";
    public static final String NAMESPACE = "urn:jboss:domain:snowdrop:1.0";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static SpringSubsystemElementParser parser = new SpringSubsystemElementParser();
    private static final DescriptionProvider SUBSYSTEM_ADD_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return SpringDescriptionProviders.getSubsystemAddDescription(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return SpringDescriptionProviders.getSubsystemDescription(locale);
        }
    };

    private static ModelNode createAddSubSystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    public void initialize(ExtensionContext context) {
        log.debug((Object)"Activating Spring Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(SUBSYSTEM_DESCRIPTION);
        registration.registerOperationHandler("add", (OperationStepHandler)SpringSubsystemAdd.INSTANCE, SUBSYSTEM_ADD_DESCRIPTION, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)SpringSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)SpringSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        log.debug((Object)"Setting up parsers");
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)parser);
    }

    private static class SpringSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final SpringSubsystemDescribeHandler INSTANCE = new SpringSubsystemDescribeHandler();

        private SpringSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.getResult().add(SpringExtension.createAddSubSystemOperation());
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class SpringSubsystemElementParser
    implements XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        SpringSubsystemElementParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            ModelNode update = new ModelNode();
            update.get("operation").set("add");
            update.get("address").add("subsystem", SpringExtension.SUBSYSTEM_NAME);
            list.add(SpringSubsystemElementParser.createAddSubSystemOperation());
        }

        private static ModelNode createAddSubSystemOperation() {
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").add("subsystem", SpringExtension.SUBSYSTEM_NAME);
            return subsystem;
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(SpringExtension.NAMESPACE, false);
            writer.writeEndElement();
        }
    }
}

