/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers.as7;

import java.util.HashSet;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.spring.deployers.as7.SpringDeployment;
import org.jboss.vfs.VirtualFile;

public class SpringStructureProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.snowdrop");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot == null) {
            return;
        }
        HashSet<VirtualFile> springContextLocations = new HashSet<VirtualFile>();
        VirtualFile metaInf = deploymentRoot.getRoot().getChild("META-INF");
        for (VirtualFile child : metaInf.getChildren()) {
            if (!child.getName().endsWith("-spring.xml")) continue;
            springContextLocations.add(child);
            log.debug((Object)("Found:" + child.getPathName()));
        }
        if (!springContextLocations.isEmpty()) {
            SpringDeployment springDeployment = new SpringDeployment(springContextLocations);
            springDeployment.attachTo(deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

