/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.cluster;

import java.lang.annotation.Annotation;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.annotation.Replicable;
import org.jboss.spring.cluster.CacheLookup;
import org.jboss.spring.cluster.CacheScope;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachePostProcessor
extends CacheLookup
implements BeanFactoryPostProcessor,
BeanPostProcessor {
    private String scopeName = "cache";

    public CachePostProcessor(PojoCache pojoCache) {
        super(pojoCache);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope(this.scopeName, (Scope)new CacheScope(this.pojoCache));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        if (beanClass.isAnnotationPresent(this.getMarkerAnnotation())) {
            Object result = this.get(beanName);
            if (result != null) {
                return result;
            }
            return this.put(beanName, bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Class<? extends Annotation> getMarkerAnnotation() {
        return Replicable.class;
    }

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }
}

