/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.cluster;

import org.jboss.cache.CacheException;
import org.jboss.cache.pojo.PojoCache;

public abstract class CacheLookup {
    private String rootName = "/pojos/";
    protected PojoCache pojoCache;

    protected CacheLookup(PojoCache pojoCache) {
        this.pojoCache = pojoCache;
    }

    protected Object get(String name) {
        try {
            return this.pojoCache.find(this.rootName + name);
        }
        catch (CacheException e) {
            System.err.println("Exception getting object from PojoCache:" + (Object)((Object)e));
            return null;
        }
    }

    protected Object put(String name, Object object) {
        try {
            return this.pojoCache.attach(this.rootName + name, object);
        }
        catch (CacheException e) {
            throw new IllegalArgumentException("Unable to put object to PojoCache: " + (Object)((Object)e));
        }
    }

    public Object remove(String name) {
        try {
            return this.pojoCache.detach(this.rootName + name);
        }
        catch (CacheException e) {
            System.err.println("Exception removing object from PojoCache:" + (Object)((Object)e));
            return null;
        }
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }
}

