/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.CommonLevelsUtil;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.metadata.spi.stack.MetaDataStack;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.spring.aop.AspectManagerFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAopProxy
implements AopProxy {
    private static Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration();
        }
    });
    private static final List<ScopeLevel> levels = new ArrayList<ScopeLevel>(CommonLevelsUtil.getSubLevels((ScopeLevel)CommonLevels.INSTANCE));
    private AdvisedSupport config;
    private AOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
    private org.jboss.reflect.spi.ConstructorInfo constructorInfo;

    public JBossAopProxy(AdvisedSupport config) {
        if (config == null) {
            throw new IllegalArgumentException("Null config");
        }
        this.config = config;
    }

    public Object getProxy() {
        return this.getProxy(null);
    }

    public Object getProxy(ClassLoader classLoader) {
        Class clazz = this.config.getTargetClass();
        if (clazz == null) {
            throw new IllegalArgumentException("Null target class");
        }
        try {
            ClassInfo classInfo = configuration.getClassInfo(clazz);
            this.constructorInfo = Config.findConstructorInfo((ClassInfo)classInfo, (String[])new String[0]);
            MetaData metaData = MetaDataStack.peek();
            boolean hasInstanceMetaData = this.rootHasSubInstanceMetaData(metaData);
            AspectManager manager = AspectManagerFactory.getAspectManager(metaData);
            ContainerCache cache = ContainerCache.initialise((AspectManager)manager, (Class)clazz, (MetaData)metaData, (boolean)hasInstanceMetaData);
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            Object target = null;
            TargetSource ts = this.config.getTargetSource();
            if (ts != null) {
                target = ts.getTarget();
            }
            if (target == null) {
                target = this.createTarget(cache, params);
            }
            params.setProxiedClass(target.getClass());
            params.setMetaData(metaData);
            params.setTarget(target);
            params.setContainerCache(cache);
            params.setMetaDataHasInstanceLevelData(hasInstanceMetaData);
            return this.proxyFactory.createAdvisedProxy(params);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private boolean rootHasSubInstanceMetaData(MetaData metaData) {
        if (metaData == null) {
            return false;
        }
        if (this.checkForMetaDataAtSubInstanceLevel(metaData)) {
            return true;
        }
        return this.rootHasMethodWithSubInstanceMetaData(metaData);
    }

    private boolean rootHasMethodWithSubInstanceMetaData(MetaData metaData) {
        for (ClassInfo info = this.constructorInfo.getDeclaringClass(); info != null; info = info.getSuperclass()) {
            MethodInfo[] methods = info.getDeclaredMethods();
            if (methods == null) continue;
            for (MethodInfo mi : methods) {
                if (!this.methodHasSubInstanceMetaData(metaData, mi)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean methodHasSubInstanceMetaData(MetaData metaData, MethodInfo mi) {
        DeclaredMethodSignature sig = new DeclaredMethodSignature(mi);
        MetaData methodMD = metaData.getComponentMetaData((Signature)sig);
        return this.checkForMetaDataAtSubInstanceLevel(methodMD);
    }

    private boolean checkForMetaDataAtSubInstanceLevel(MetaData metaData) {
        if (metaData != null) {
            for (ScopeLevel level : levels) {
                if (!this.hasMetaDataAtLevel(metaData, level)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasMetaDataAtLevel(MetaData metaData, ScopeLevel level) {
        MetaData levelMetaData = metaData.getScopeMetaData(level);
        if (levelMetaData != null && !levelMetaData.isEmpty()) {
            int annotationsSize;
            Object[] allMetaData = levelMetaData.getMetaData();
            Annotation[] annotations = levelMetaData.getAnnotations();
            int allSize = allMetaData.length;
            int n = annotationsSize = annotations != null ? annotations.length : 0;
            if (allSize > annotationsSize) {
                return true;
            }
            if (annotationsSize > 0) {
                return true;
            }
        }
        return false;
    }

    private Object createTarget(ContainerCache cache, AOPProxyFactoryParameters params) throws Throwable {
        Advisor advisor = cache.getAdvisor();
        if (advisor != null) {
            Interceptor[] interceptors;
            ConstructorInfo aopinfo = this.findAopConstructorInfo(advisor);
            Interceptor[] interceptorArray = interceptors = aopinfo != null ? aopinfo.getInterceptors() : null;
            if (interceptors != null) {
                ConstructorInvocation inv = new ConstructorInvocation(aopinfo, aopinfo.getInterceptors());
                inv.setArguments(this.getArguments());
                return inv.invokeNext();
            }
            if (this.constructorInfo.getParameterTypes().length > 0) {
                Constructor<?> constructor = null;
                if (aopinfo == null) {
                    Constructor<?>[] ctors;
                    Class clazz = advisor.getClazz();
                    for (Constructor<?> ctor : ctors = clazz.getConstructors()) {
                        if (!this.matchConstructor(ctor)) continue;
                        constructor = ctor;
                        break;
                    }
                } else {
                    constructor = aopinfo.getConstructor();
                }
                params.setCtor((Class[])constructor.getParameterTypes(), this.getArguments());
            }
        }
        return this.constructorInfo.newInstance(this.getArguments());
    }

    private ConstructorInfo findAopConstructorInfo(Advisor advisor) {
        ConstructorInfo[] infos = advisor.getConstructorInfos();
        for (int i = 0; i < infos.length; ++i) {
            if (!this.matchConstructor(infos[i].getConstructor())) continue;
            return infos[i];
        }
        return null;
    }

    private boolean matchConstructor(Constructor<?> ctor) {
        Class<?>[] ctorParams;
        TypeInfo[] params = this.constructorInfo.getParameterTypes();
        if (params.length == (ctorParams = ctor.getParameterTypes()).length) {
            boolean match = true;
            for (int p = 0; p < params.length; ++p) {
                if (params[p].getName().equals(ctorParams[p].getName())) continue;
                match = false;
                break;
            }
            if (match) {
                return true;
            }
        }
        return false;
    }

    protected Object[] getArguments() {
        return new Object[0];
    }

    static {
        levels.remove(CommonLevels.JOINPOINT);
    }
}

