/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.aop;

import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.metadata.plugins.scope.ApplicationScope;
import org.jboss.metadata.plugins.scope.DeploymentScope;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.stack.MetaDataStack;
import org.jboss.util.JBossStringBuilder;

public class AspectManagerFactory {
    public static AspectManager getAspectManager() {
        return AspectManagerFactory.getAspectManager(MetaDataStack.peek());
    }

    public static AspectManager getAspectManager(MetaData md) {
        AspectManager manager = AspectManager.instance();
        if (md != null) {
            AspectManager metaDataManager = (AspectManager)md.getMetaData(AspectManager.class);
            if (metaDataManager != null) {
                return metaDataManager;
            }
            ApplicationScope app = (ApplicationScope)md.getMetaData(ApplicationScope.class);
            DeploymentScope dep = (DeploymentScope)md.getMetaData(DeploymentScope.class);
            if (app != null && dep != null) {
                String name;
                JBossStringBuilder fqn = new JBossStringBuilder("/");
                AspectManager sub = null;
                if (app != null) {
                    name = "APPLICATION=" + app.value();
                    fqn.append(name);
                    fqn.append("/");
                    sub = manager.findManagerByName(fqn.toString());
                    if (sub == null) {
                        sub = AspectManagerFactory.createNewDomain(manager, name);
                    }
                }
                if (dep != null) {
                    name = "DEPLOYMENT=" + dep.value();
                    fqn.append(name);
                    fqn.append("/");
                    AspectManager parent = sub;
                    sub = manager.findManagerByName(fqn.toString());
                    if (sub == null) {
                        sub = AspectManagerFactory.createNewDomain(parent, name);
                    }
                }
                return sub;
            }
        }
        return manager;
    }

    private static AspectManager createNewDomain(AspectManager parent, String name) {
        Domain domain = new Domain(parent, name, true);
        domain.setInheritsBindings(true);
        domain.setInheritsDeclarations(true);
        return domain;
    }
}

