/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.SecurityActions;

public class ClassLoaderAsset
implements Asset {
    private String resourceName;
    private ClassLoader classLoader;

    public ClassLoaderAsset(String resourceName) {
        this(resourceName, SecurityActions.getThreadContextClassLoader());
    }

    public ClassLoaderAsset(String resourceName, ClassLoader classLoader) {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(classLoader, "ClassLoader must be specified");
        Validate.notNull(classLoader.getResource(resourceName), resourceName + " not found in classloader " + classLoader);
        this.resourceName = resourceName;
        this.classLoader = classLoader;
    }

    public InputStream openStream() {
        return new BufferedInputStream(this.classLoader.getResourceAsStream(this.resourceName), 8192);
    }
}

