/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public final class AssetUtil {
    public static final String DELIMITER_CLASS_NAME_PATH = "\\.";
    public static final String DELIMITER_RESOURCE_PATH = "/";
    private static final String EXTENSION_CLASS = ".class";

    private AssetUtil() {
    }

    public static ArchivePath getPathForClassloaderResource(String resourceName) {
        String extractedPath = null;
        if (resourceName.lastIndexOf(47) != -1) {
            extractedPath = resourceName.substring(0, resourceName.lastIndexOf(47));
        }
        return new BasicPath(extractedPath);
    }

    public static String getNameForClassloaderResource(String resourceName) {
        String fileName = resourceName;
        if (resourceName.indexOf(47) != -1) {
            fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1, resourceName.length());
        }
        return fileName;
    }

    public static ArchivePath getFullPathForClassResource(Class<?> clazz) {
        String classResourceDelimiter = clazz.getName().replaceAll(DELIMITER_CLASS_NAME_PATH, DELIMITER_RESOURCE_PATH);
        String classFullPath = classResourceDelimiter + EXTENSION_CLASS;
        return new BasicPath(classFullPath);
    }
}

