/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class MemoryMapArchiveBase<T extends Archive<T>>
extends ArchiveBase<T>
implements Archive<T> {
    private static final Logger log = Logger.getLogger(MemoryMapArchiveBase.class.getName());
    private static final char NEWLINE = '\n';
    private static final char COLON = ':';
    private final Map<ArchivePath, Asset> content = new ConcurrentHashMap<ArchivePath, Asset>();
    private final Map<ArchivePath, ArchiveAsset> nestedArchives = new ConcurrentHashMap<ArchivePath, ArchiveAsset>();

    public MemoryMapArchiveBase(ExtensionLoader extensionLoader) {
        this("Archive-" + UUID.randomUUID().toString() + ".jar", extensionLoader);
    }

    public MemoryMapArchiveBase(String archiveName, ExtensionLoader extensionLoader) {
        super(archiveName, extensionLoader);
    }

    public T add(Asset asset, ArchivePath path) {
        Validate.notNull(asset, "No asset was specified");
        Validate.notNull(path, "No path was specified");
        this.content.put(path, asset);
        return this.covariantReturn();
    }

    @Override
    public T add(Archive<?> archive, ArchivePath path) {
        super.add(archive, path);
        BasicPath archivePath = new BasicPath(path, archive.getName());
        Asset asset = this.get(archivePath);
        if (asset instanceof ArchiveAsset) {
            ArchiveAsset archiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(asset);
            this.nestedArchives.put(archivePath, archiveAsset);
        }
        return this.covariantReturn();
    }

    public boolean contains(ArchivePath path) {
        Validate.notNull(path, "No path was specified");
        boolean found = this.content.containsKey(path);
        if (!found) {
            found = this.nestedContains(path);
        }
        return found;
    }

    public boolean delete(ArchivePath path) {
        Validate.notNull(path, "No path was specified");
        return this.content.remove(path) != null;
    }

    public Asset get(ArchivePath path) {
        Validate.notNull(path, "No path was specified");
        Asset asset = this.content.get(path);
        if (asset == null && this.contains(path)) {
            asset = this.getNestedAsset(path);
        }
        return asset;
    }

    public Map<ArchivePath, Asset> getContent() {
        return Collections.unmodifiableMap(this.content);
    }

    public Map<ArchivePath, Asset> getContent(Filter<ArchivePath> filter) {
        Validate.notNull(filter, "Filter must be specified");
        HashMap<ArchivePath, Asset> filteredContent = new HashMap<ArchivePath, Asset>();
        for (Map.Entry<ArchivePath, Asset> contentEntry : this.content.entrySet()) {
            if (!filter.include((Object)contentEntry.getKey())) continue;
            filteredContent.put(contentEntry.getKey(), contentEntry.getValue());
        }
        return filteredContent;
    }

    private boolean nestedContains(ArchivePath path) {
        for (Map.Entry<ArchivePath, ArchiveAsset> nestedArchiveEntry : this.nestedArchives.entrySet()) {
            ArchivePath archivePath = nestedArchiveEntry.getKey();
            ArchiveAsset archiveAsset = nestedArchiveEntry.getValue();
            if (!this.startsWith(path, archivePath)) continue;
            Archive<?> nestedArchive = archiveAsset.getArchive();
            ArchivePath nestedAssetPath = this.getNestedPath(path, archivePath);
            return nestedArchive.contains(nestedAssetPath);
        }
        return false;
    }

    private Asset getNestedAsset(ArchivePath path) {
        for (Map.Entry<ArchivePath, ArchiveAsset> nestedArchiveEntry : this.nestedArchives.entrySet()) {
            ArchivePath archivePath = nestedArchiveEntry.getKey();
            ArchiveAsset archiveAsset = nestedArchiveEntry.getValue();
            if (!this.startsWith(path, archivePath)) continue;
            Archive<?> nestedArchive = archiveAsset.getArchive();
            ArchivePath nestedAssetPath = this.getNestedPath(path, archivePath);
            return nestedArchive.get(nestedAssetPath);
        }
        return null;
    }

    private boolean startsWith(ArchivePath fullPath, ArchivePath startingPath) {
        String context = fullPath.get();
        String startingContext = startingPath.get();
        return context.startsWith(startingContext);
    }

    private ArchivePath getNestedPath(ArchivePath fullPath, ArchivePath basePath) {
        String context = fullPath.get();
        String baseContent = basePath.get();
        String nestedArchiveContext = context.substring(baseContent.length());
        return new BasicPath(nestedArchiveContext);
    }
}

