/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

class CRCInputStream
extends FilterInputStream {
    private final CRC32 crc;
    private long bytesProcessed = 0L;

    protected CRCInputStream(InputStream in, CRC32 crc) {
        super(in);
        this.crc = crc;
    }

    protected long getBytesProcessed() {
        return this.bytesProcessed;
    }

    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            this.crc.update(c);
            ++this.bytesProcessed;
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int len = super.read(b);
        if (len != -1) {
            this.crc.update(b, 0, len);
            this.bytesProcessed += (long)len;
        }
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if ((len = super.read(b, off, len)) != -1) {
            this.crc.update(b, off, len);
            this.bytesProcessed += (long)len;
        }
        return len;
    }
}

