/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ArchiveJarInputStream;
import org.jboss.shrinkwrap.impl.base.exporter.zip.CRCInputStream;
import org.jboss.shrinkwrap.impl.base.exporter.zip.DeflaterInputStream;

class ArchiveJarZipInputStream
extends InputStream {
    private static final int MINIMUM_BUFFER_LENGTH = 1024;
    private final ArchiveJarInputStream virtualJarInputStream;
    private State currentState = State.NOT_STARTED;
    private final List<ProcessedEntry> processedEntries = new LinkedList<ProcessedEntry>();
    private ProcessedEntry currentEntry;
    private final ByteBuffer buffer;
    private final CRC32 crc = new CRC32();
    private int currentCentralEntryIdx;
    private long centralOffset;
    private long totalRead;
    private CRCInputStream currentCRCInputStream;
    private InputStream currentInputStream;

    public ArchiveJarZipInputStream(ArchiveJarInputStream virtualJarInputStream) {
        this(virtualJarInputStream, 1024);
    }

    public ArchiveJarZipInputStream(ArchiveJarInputStream virtualJarInputStream, int bufferLength) {
        if (virtualJarInputStream == null) {
            throw new IllegalArgumentException("virtualJarInputStream is required");
        }
        if (bufferLength < 1024) {
            throw new IllegalArgumentException("The totalBufferLength must be larger than 1024");
        }
        this.virtualJarInputStream = virtualJarInputStream;
        this.buffer = new ByteBuffer(bufferLength);
    }

    public int read() throws IOException {
        int readByte = -1;
        while (this.currentState != null && (readByte = this.currentState.read(this)) == -1) {
            this.currentState = this.currentState.getNextState(this);
        }
        if (readByte != -1) {
            ++this.totalRead;
        }
        return readByte;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r = -1;
        while (this.currentState != null && (r = this.currentState.read(this, b, off, len)) == -1) {
            this.currentState = this.currentState.getNextState(this);
        }
        if (r != -1) {
            this.totalRead += (long)r;
        }
        return r;
    }

    public void close() throws IOException {
        this.virtualJarInputStream.close();
        super.close();
    }

    private void closeCurrent() throws IOException {
        this.virtualJarInputStream.closeEntry();
        this.currentEntry.crc = this.crc.getValue();
        this.currentEntry.uncompressedSize = this.currentCRCInputStream.getBytesProcessed();
        this.crc.reset();
    }

    private boolean bufferLocalFileHeader() throws IOException {
        this.buffer.reset();
        JarEntry jarEntry = this.virtualJarInputStream.getNextJarEntry();
        if (jarEntry == null) {
            return false;
        }
        this.currentEntry = new ProcessedEntry(jarEntry, this.totalRead);
        this.processedEntries.add(this.currentEntry);
        this.bufferInt(67324752L);
        this.bufferShort(10);
        this.bufferShort(8);
        this.bufferShort(8);
        this.bufferInt(jarEntry.getTime());
        this.bufferInt(0L);
        this.bufferInt(0L);
        this.bufferInt(0L);
        byte[] nameBytes = jarEntry.getName().getBytes("UTF8");
        this.bufferShort(nameBytes.length);
        this.bufferShort(0);
        this.buffer(nameBytes);
        return true;
    }

    private void bufferDataDescriptor() {
        this.buffer.reset();
        this.bufferInt(134695760L);
        this.bufferInt(this.currentEntry.crc);
        this.bufferInt(this.currentEntry.compressedSize);
        long uncompressedSize = this.currentEntry.uncompressedSize;
        assert (uncompressedSize != -1L);
        this.bufferInt(uncompressedSize);
    }

    private boolean bufferNextCentralFileHeader() throws IOException {
        this.buffer.reset();
        if (this.currentCentralEntryIdx == this.processedEntries.size()) {
            return false;
        }
        ProcessedEntry entry = this.processedEntries.get(this.currentCentralEntryIdx++);
        JarEntry jarEntry = entry.jarEntry;
        this.bufferInt(33639248L);
        this.bufferShort(10);
        this.bufferShort(10);
        this.bufferShort(8);
        this.bufferShort(8);
        this.bufferInt(ArchiveJarInputStream.javaToDosTime(jarEntry.getTime()));
        this.bufferInt(entry.crc);
        this.bufferInt(entry.compressedSize);
        this.bufferInt(entry.uncompressedSize);
        byte[] nameBytes = jarEntry.getName().getBytes("UTF8");
        this.bufferShort(nameBytes.length);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferInt(0L);
        this.bufferInt(entry.offset);
        this.buffer(nameBytes);
        assert (46 + nameBytes.length == this.buffer.size()) : "invalid CEN header (bad header size)";
        return true;
    }

    private void bufferCentralDirectoryEnd() throws IOException {
        this.buffer.reset();
        long lengthOfCentral = this.totalRead - this.centralOffset;
        int count = this.processedEntries.size();
        this.bufferInt(101010256L);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferShort(count);
        this.bufferShort(count);
        this.bufferInt(lengthOfCentral);
        this.bufferInt(this.centralOffset);
        this.bufferShort(0);
    }

    private void bufferInt(long i) {
        this.buffer((byte)(i & 0xFFL));
        this.buffer((byte)(i >>> 8 & 0xFFL));
        this.buffer((byte)(i >>> 16 & 0xFFL));
        this.buffer((byte)(i >>> 24 & 0xFFL));
    }

    private void bufferShort(int i) {
        this.buffer((byte)(i & 0xFF));
        this.buffer((byte)(i >>> 8 & 0xFF));
    }

    private void buffer(byte b) {
        if (!this.buffer.hasCapacity()) {
            throw new IllegalStateException("Buffer does not have enough capacity");
        }
        this.buffer.put(b);
    }

    private void buffer(byte[] bytes) {
        for (byte b : bytes) {
            this.buffer(b);
        }
    }

    private static class ByteBuffer {
        private final int bufferLength;
        private final byte[] buffer;
        private int bufferPosition;
        private int bufferDepth;

        private ByteBuffer(int bufferLength) {
            this.buffer = new byte[bufferLength];
            this.bufferLength = bufferLength;
        }

        private boolean hasRemaining() {
            return this.bufferPosition < this.bufferDepth;
        }

        private boolean hasCapacity() {
            return this.bufferDepth < this.bufferLength;
        }

        private byte get() {
            return this.buffer[this.bufferPosition++];
        }

        private void put(byte b) {
            this.buffer[this.bufferDepth++] = b;
        }

        private void reset() {
            this.bufferPosition = 0;
            this.bufferDepth = 0;
        }

        private int size() {
            return this.bufferDepth;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_STARTED{

            State transition(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                return LOCAL_ENTRY_HEADER;
            }
        }
        ,
        LOCAL_ENTRY_HEADER{
            boolean buffered;

            void init(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                this.buffered = jarFileInputStream.bufferLocalFileHeader();
            }

            int read(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                ByteBuffer buffer = jarFileInputStream.buffer;
                if (this.buffered && buffer.hasRemaining()) {
                    return buffer.get();
                }
                return -1;
            }

            State transition(ArchiveJarZipInputStream virtualJarFileInputStream) throws IOException {
                if (this.buffered) {
                    return ENTRY_CONTENT;
                }
                return START_CENTRAL_DIRECTORY;
            }
        }
        ,
        ENTRY_CONTENT{

            void init(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                jarFileInputStream.crc.reset();
                jarFileInputStream.currentCRCInputStream = new CRCInputStream(jarFileInputStream.virtualJarInputStream, jarFileInputStream.crc);
                jarFileInputStream.currentInputStream = new DeflaterInputStream(jarFileInputStream.currentCRCInputStream, new Deflater(-1, true));
            }

            int read(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                InputStream in = jarFileInputStream.currentInputStream;
                int c = in.read();
                if (c != -1) {
                    jarFileInputStream.currentEntry.compressedSize++;
                }
                return c;
            }

            int read(ArchiveJarZipInputStream jarFileInputStream, byte[] b, int off, int len) throws IOException {
                InputStream in = jarFileInputStream.currentInputStream;
                int r = in.read(b, off, len);
                if (r != -1) {
                    jarFileInputStream.currentEntry.compressedSize += r;
                }
                return r;
            }

            State transition(ArchiveJarZipInputStream virtualJarFileInputStream) throws IOException {
                virtualJarFileInputStream.closeCurrent();
                return DATA_DESCRIPTOR;
            }
        }
        ,
        DATA_DESCRIPTOR{

            void init(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                jarFileInputStream.bufferDataDescriptor();
            }

            int read(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                ByteBuffer buffer = jarFileInputStream.buffer;
                if (buffer.hasRemaining()) {
                    return buffer.get();
                }
                return -1;
            }

            State transition(ArchiveJarZipInputStream virtualJarFileInputStream) throws IOException {
                return LOCAL_ENTRY_HEADER;
            }
        }
        ,
        START_CENTRAL_DIRECTORY{

            void init(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                jarFileInputStream.centralOffset = jarFileInputStream.totalRead;
            }

            State transition(ArchiveJarZipInputStream virtualJarFileInputStream) throws IOException {
                return CENTRAL_ENTRY_HEADER;
            }
        }
        ,
        CENTRAL_ENTRY_HEADER{
            boolean buffered;

            void init(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                this.buffered = jarFileInputStream.bufferNextCentralFileHeader();
            }

            int read(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                ByteBuffer buffer = jarFileInputStream.buffer;
                if (this.buffered && buffer.hasRemaining()) {
                    return buffer.get() & 0xFF;
                }
                return -1;
            }

            State transition(ArchiveJarZipInputStream virtualJarFileInputStream) throws IOException {
                if (this.buffered) {
                    return CENTRAL_ENTRY_HEADER;
                }
                return CENTRAL_END;
            }
        }
        ,
        CENTRAL_END{

            void init(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                jarFileInputStream.bufferCentralDirectoryEnd();
            }

            int read(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
                ByteBuffer buffer = jarFileInputStream.buffer;
                if (buffer.hasRemaining()) {
                    return buffer.get();
                }
                return -1;
            }

            State transition(ArchiveJarZipInputStream virtualJarFileInputStream) throws IOException {
                return null;
            }
        };


        void init(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
        }

        abstract State transition(ArchiveJarZipInputStream var1) throws IOException;

        int read(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
            return -1;
        }

        int read(ArchiveJarZipInputStream jarFileInputStream, byte[] b, int off, int len) throws IOException {
            int i;
            int c = this.read(jarFileInputStream);
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            try {
                for (i = 1; i < len && (c = this.read(jarFileInputStream)) != -1; ++i) {
                    b[off + i] = (byte)c;
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
            return i;
        }

        State getNextState(ArchiveJarZipInputStream jarFileInputStream) throws IOException {
            State nextState = this.transition(jarFileInputStream);
            if (nextState != null) {
                nextState.init(jarFileInputStream);
            }
            return nextState;
        }
    }

    private class ProcessedEntry {
        private final JarEntry jarEntry;
        private final long offset;
        private long crc;
        private long compressedSize;
        private long uncompressedSize;

        private ProcessedEntry(JarEntry jarEntry, long offset) {
            this.jarEntry = jarEntry;
            this.offset = offset;
        }
    }
}

